/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.providerhub.ProviderHubManager;
import com.azure.resourcemanager.providerhub.fluent.NotificationRegistrationsClient;
import com.azure.resourcemanager.providerhub.fluent.models.NotificationRegistrationInner;
import com.azure.resourcemanager.providerhub.implementation.NotificationRegistrationImpl;
import com.azure.resourcemanager.providerhub.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.providerhub.models.NotificationRegistration;
import com.azure.resourcemanager.providerhub.models.NotificationRegistrations;

public final class NotificationRegistrationsImpl
implements NotificationRegistrations {
    private static final ClientLogger LOGGER = new ClientLogger(NotificationRegistrationsImpl.class);
    private final NotificationRegistrationsClient innerClient;
    private final ProviderHubManager serviceManager;

    public NotificationRegistrationsImpl(NotificationRegistrationsClient innerClient, ProviderHubManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<NotificationRegistration> getWithResponse(String providerNamespace, String notificationRegistrationName, Context context) {
        Response<NotificationRegistrationInner> inner = this.serviceClient().getWithResponse(providerNamespace, notificationRegistrationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new NotificationRegistrationImpl((NotificationRegistrationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public NotificationRegistration get(String providerNamespace, String notificationRegistrationName) {
        NotificationRegistrationInner inner = this.serviceClient().get(providerNamespace, notificationRegistrationName);
        if (inner != null) {
            return new NotificationRegistrationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteByResourceGroupWithResponse(String providerNamespace, String notificationRegistrationName, Context context) {
        return this.serviceClient().deleteWithResponse(providerNamespace, notificationRegistrationName, context);
    }

    @Override
    public void deleteByResourceGroup(String providerNamespace, String notificationRegistrationName) {
        this.serviceClient().delete(providerNamespace, notificationRegistrationName);
    }

    @Override
    public PagedIterable<NotificationRegistration> listByProviderRegistration(String providerNamespace) {
        PagedIterable<NotificationRegistrationInner> inner = this.serviceClient().listByProviderRegistration(providerNamespace);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NotificationRegistrationImpl((NotificationRegistrationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<NotificationRegistration> listByProviderRegistration(String providerNamespace, Context context) {
        PagedIterable<NotificationRegistrationInner> inner = this.serviceClient().listByProviderRegistration(providerNamespace, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NotificationRegistrationImpl((NotificationRegistrationInner)((Object)inner1), this.manager()));
    }

    @Override
    public NotificationRegistration getById(String id) {
        String providerNamespace = ResourceManagerUtils.getValueFromIdByName(id, "providerRegistrations");
        if (providerNamespace == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'providerRegistrations'.", id)));
        }
        String notificationRegistrationName = ResourceManagerUtils.getValueFromIdByName(id, "notificationRegistrations");
        if (notificationRegistrationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'notificationRegistrations'.", id)));
        }
        return (NotificationRegistration)this.getWithResponse(providerNamespace, notificationRegistrationName, Context.NONE).getValue();
    }

    @Override
    public Response<NotificationRegistration> getByIdWithResponse(String id, Context context) {
        String providerNamespace = ResourceManagerUtils.getValueFromIdByName(id, "providerRegistrations");
        if (providerNamespace == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'providerRegistrations'.", id)));
        }
        String notificationRegistrationName = ResourceManagerUtils.getValueFromIdByName(id, "notificationRegistrations");
        if (notificationRegistrationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'notificationRegistrations'.", id)));
        }
        return this.getWithResponse(providerNamespace, notificationRegistrationName, context);
    }

    @Override
    public void deleteById(String id) {
        String providerNamespace = ResourceManagerUtils.getValueFromIdByName(id, "providerRegistrations");
        if (providerNamespace == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'providerRegistrations'.", id)));
        }
        String notificationRegistrationName = ResourceManagerUtils.getValueFromIdByName(id, "notificationRegistrations");
        if (notificationRegistrationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'notificationRegistrations'.", id)));
        }
        this.deleteByResourceGroupWithResponse(providerNamespace, notificationRegistrationName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String providerNamespace = ResourceManagerUtils.getValueFromIdByName(id, "providerRegistrations");
        if (providerNamespace == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'providerRegistrations'.", id)));
        }
        String notificationRegistrationName = ResourceManagerUtils.getValueFromIdByName(id, "notificationRegistrations");
        if (notificationRegistrationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'notificationRegistrations'.", id)));
        }
        return this.deleteByResourceGroupWithResponse(providerNamespace, notificationRegistrationName, context);
    }

    private NotificationRegistrationsClient serviceClient() {
        return this.innerClient;
    }

    private ProviderHubManager manager() {
        return this.serviceManager;
    }

    @Override
    public NotificationRegistrationImpl define(String name) {
        return new NotificationRegistrationImpl(name, this.manager());
    }
}

