/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.providerhub.ProviderHubManager;
import com.azure.resourcemanager.providerhub.fluent.models.NotificationRegistrationInner;
import com.azure.resourcemanager.providerhub.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.providerhub.models.NotificationRegistration;
import com.azure.resourcemanager.providerhub.models.NotificationRegistrationProperties;

public final class NotificationRegistrationImpl
implements NotificationRegistration,
NotificationRegistration.Definition,
NotificationRegistration.Update {
    private NotificationRegistrationInner innerObject;
    private final ProviderHubManager serviceManager;
    private String providerNamespace;
    private String notificationRegistrationName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public NotificationRegistrationProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public NotificationRegistrationInner innerModel() {
        return this.innerObject;
    }

    private ProviderHubManager manager() {
        return this.serviceManager;
    }

    @Override
    public NotificationRegistrationImpl withExistingProviderRegistration(String providerNamespace) {
        this.providerNamespace = providerNamespace;
        return this;
    }

    @Override
    public NotificationRegistration create() {
        this.innerObject = (NotificationRegistrationInner)((Object)this.serviceManager.serviceClient().getNotificationRegistrations().createOrUpdateWithResponse(this.providerNamespace, this.notificationRegistrationName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public NotificationRegistration create(Context context) {
        this.innerObject = (NotificationRegistrationInner)((Object)this.serviceManager.serviceClient().getNotificationRegistrations().createOrUpdateWithResponse(this.providerNamespace, this.notificationRegistrationName, this.innerModel(), context).getValue());
        return this;
    }

    NotificationRegistrationImpl(String name, ProviderHubManager serviceManager) {
        this.innerObject = new NotificationRegistrationInner();
        this.serviceManager = serviceManager;
        this.notificationRegistrationName = name;
    }

    @Override
    public NotificationRegistrationImpl update() {
        return this;
    }

    @Override
    public NotificationRegistration apply() {
        this.innerObject = (NotificationRegistrationInner)((Object)this.serviceManager.serviceClient().getNotificationRegistrations().createOrUpdateWithResponse(this.providerNamespace, this.notificationRegistrationName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public NotificationRegistration apply(Context context) {
        this.innerObject = (NotificationRegistrationInner)((Object)this.serviceManager.serviceClient().getNotificationRegistrations().createOrUpdateWithResponse(this.providerNamespace, this.notificationRegistrationName, this.innerModel(), context).getValue());
        return this;
    }

    NotificationRegistrationImpl(NotificationRegistrationInner innerObject, ProviderHubManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.providerNamespace = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "providerRegistrations");
        this.notificationRegistrationName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "notificationRegistrations");
    }

    @Override
    public NotificationRegistration refresh() {
        this.innerObject = (NotificationRegistrationInner)((Object)this.serviceManager.serviceClient().getNotificationRegistrations().getWithResponse(this.providerNamespace, this.notificationRegistrationName, Context.NONE).getValue());
        return this;
    }

    @Override
    public NotificationRegistration refresh(Context context) {
        this.innerObject = (NotificationRegistrationInner)((Object)this.serviceManager.serviceClient().getNotificationRegistrations().getWithResponse(this.providerNamespace, this.notificationRegistrationName, context).getValue());
        return this;
    }

    @Override
    public NotificationRegistrationImpl withProperties(NotificationRegistrationProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

