/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.providerhub.ProviderHubManager;
import com.azure.resourcemanager.providerhub.fluent.NewRegionFrontloadReleasesClient;
import com.azure.resourcemanager.providerhub.fluent.models.DefaultRolloutInner;
import com.azure.resourcemanager.providerhub.fluent.models.ResourceProviderManifestInner;
import com.azure.resourcemanager.providerhub.implementation.DefaultRolloutImpl;
import com.azure.resourcemanager.providerhub.implementation.ResourceProviderManifestImpl;
import com.azure.resourcemanager.providerhub.models.DefaultRollout;
import com.azure.resourcemanager.providerhub.models.FrontloadPayload;
import com.azure.resourcemanager.providerhub.models.NewRegionFrontloadReleases;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManifest;

public final class NewRegionFrontloadReleasesImpl
implements NewRegionFrontloadReleases {
    private static final ClientLogger LOGGER = new ClientLogger(NewRegionFrontloadReleasesImpl.class);
    private final NewRegionFrontloadReleasesClient innerClient;
    private final ProviderHubManager serviceManager;

    public NewRegionFrontloadReleasesImpl(NewRegionFrontloadReleasesClient innerClient, ProviderHubManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ResourceProviderManifest> generateManifestWithResponse(String providerNamespace, FrontloadPayload properties, Context context) {
        Response<ResourceProviderManifestInner> inner = this.serviceClient().generateManifestWithResponse(providerNamespace, properties, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ResourceProviderManifestImpl((ResourceProviderManifestInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ResourceProviderManifest generateManifest(String providerNamespace, FrontloadPayload properties) {
        ResourceProviderManifestInner inner = this.serviceClient().generateManifest(providerNamespace, properties);
        if (inner != null) {
            return new ResourceProviderManifestImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<DefaultRollout> createOrUpdateWithResponse(String providerNamespace, String releaseName, FrontloadPayload properties, Context context) {
        Response<DefaultRolloutInner> inner = this.serviceClient().createOrUpdateWithResponse(providerNamespace, releaseName, properties, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DefaultRolloutImpl((DefaultRolloutInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DefaultRollout createOrUpdate(String providerNamespace, String releaseName, FrontloadPayload properties) {
        DefaultRolloutInner inner = this.serviceClient().createOrUpdate(providerNamespace, releaseName, properties);
        if (inner != null) {
            return new DefaultRolloutImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<DefaultRollout> getWithResponse(String providerNamespace, String releaseName, Context context) {
        Response<DefaultRolloutInner> inner = this.serviceClient().getWithResponse(providerNamespace, releaseName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DefaultRolloutImpl((DefaultRolloutInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DefaultRollout get(String providerNamespace, String releaseName) {
        DefaultRolloutInner inner = this.serviceClient().get(providerNamespace, releaseName);
        if (inner != null) {
            return new DefaultRolloutImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> stopWithResponse(String providerNamespace, String releaseName, Context context) {
        return this.serviceClient().stopWithResponse(providerNamespace, releaseName, context);
    }

    @Override
    public void stop(String providerNamespace, String releaseName) {
        this.serviceClient().stop(providerNamespace, releaseName);
    }

    private NewRegionFrontloadReleasesClient serviceClient() {
        return this.innerClient;
    }

    private ProviderHubManager manager() {
        return this.serviceManager;
    }
}

