/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.providerhub.fluent.NewRegionFrontloadReleasesClient;
import com.azure.resourcemanager.providerhub.fluent.models.DefaultRolloutInner;
import com.azure.resourcemanager.providerhub.fluent.models.ResourceProviderManifestInner;
import com.azure.resourcemanager.providerhub.implementation.ProviderHubImpl;
import com.azure.resourcemanager.providerhub.models.FrontloadPayload;
import reactor.core.publisher.Mono;

public final class NewRegionFrontloadReleasesClientImpl
implements NewRegionFrontloadReleasesClient {
    private final NewRegionFrontloadReleasesService service;
    private final ProviderHubImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(NewRegionFrontloadReleasesClientImpl.class);

    NewRegionFrontloadReleasesClientImpl(ProviderHubImpl client) {
        this.service = (NewRegionFrontloadReleasesService)RestProxy.create(NewRegionFrontloadReleasesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ResourceProviderManifestInner>> generateManifestWithResponseAsync(String providerNamespace, FrontloadPayload properties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (properties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.generateManifest(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, this.client.getApiVersion(), properties, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ResourceProviderManifestInner> generateManifestAsync(String providerNamespace, FrontloadPayload properties) {
        return this.generateManifestWithResponseAsync(providerNamespace, properties).flatMap(res -> Mono.justOrEmpty((Object)((ResourceProviderManifestInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ResourceProviderManifestInner> generateManifestWithResponse(String providerNamespace, FrontloadPayload properties, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (properties == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String accept = "application/json";
        return this.service.generateManifestSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, this.client.getApiVersion(), properties, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResourceProviderManifestInner generateManifest(String providerNamespace, FrontloadPayload properties) {
        return (ResourceProviderManifestInner)this.generateManifestWithResponse(providerNamespace, properties, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DefaultRolloutInner>> createOrUpdateWithResponseAsync(String providerNamespace, String releaseName, FrontloadPayload properties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (releaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter releaseName is required and cannot be null."));
        }
        if (properties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, releaseName, this.client.getApiVersion(), properties, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DefaultRolloutInner> createOrUpdateAsync(String providerNamespace, String releaseName, FrontloadPayload properties) {
        return this.createOrUpdateWithResponseAsync(providerNamespace, releaseName, properties).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DefaultRolloutInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DefaultRolloutInner> createOrUpdateWithResponse(String providerNamespace, String releaseName, FrontloadPayload properties, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (releaseName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter releaseName is required and cannot be null."));
        }
        if (properties == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, releaseName, this.client.getApiVersion(), properties, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DefaultRolloutInner createOrUpdate(String providerNamespace, String releaseName, FrontloadPayload properties) {
        return (DefaultRolloutInner)((Object)this.createOrUpdateWithResponse(providerNamespace, releaseName, properties, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DefaultRolloutInner>> getWithResponseAsync(String providerNamespace, String releaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (releaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter releaseName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, releaseName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DefaultRolloutInner> getAsync(String providerNamespace, String releaseName) {
        return this.getWithResponseAsync(providerNamespace, releaseName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DefaultRolloutInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DefaultRolloutInner> getWithResponse(String providerNamespace, String releaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (releaseName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter releaseName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, releaseName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DefaultRolloutInner get(String providerNamespace, String releaseName) {
        return (DefaultRolloutInner)((Object)this.getWithResponse(providerNamespace, releaseName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> stopWithResponseAsync(String providerNamespace, String releaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (releaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter releaseName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.stop(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, releaseName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> stopAsync(String providerNamespace, String releaseName) {
        return this.stopWithResponseAsync(providerNamespace, releaseName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> stopWithResponse(String providerNamespace, String releaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (releaseName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter releaseName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.stopSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, releaseName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stop(String providerNamespace, String releaseName) {
        this.stopWithResponse(providerNamespace, releaseName, Context.NONE);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ProviderHubNewRegionFrontloadReleases")
    public static interface NewRegionFrontloadReleasesService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/generateNewRegionFrontloadManifest")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ResourceProviderManifestInner>> generateManifest(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") FrontloadPayload var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/generateNewRegionFrontloadManifest")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ResourceProviderManifestInner> generateManifestSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") FrontloadPayload var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/newRegionFrontloadRelease/{releaseName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DefaultRolloutInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="releaseName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") FrontloadPayload var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/newRegionFrontloadRelease/{releaseName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DefaultRolloutInner> createOrUpdateSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="releaseName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") FrontloadPayload var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/newRegionFrontloadRelease/{releaseName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DefaultRolloutInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="releaseName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/newRegionFrontloadRelease/{releaseName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DefaultRolloutInner> getSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="releaseName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/newRegionFrontloadRelease/{releaseName}/stop")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> stop(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="releaseName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/newRegionFrontloadRelease/{releaseName}/stop")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<Void> stopSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="releaseName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

