/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.providerhub.ProviderHubManager;
import com.azure.resourcemanager.providerhub.fluent.DefaultRolloutsClient;
import com.azure.resourcemanager.providerhub.fluent.models.DefaultRolloutInner;
import com.azure.resourcemanager.providerhub.implementation.DefaultRolloutImpl;
import com.azure.resourcemanager.providerhub.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.providerhub.models.DefaultRollout;
import com.azure.resourcemanager.providerhub.models.DefaultRollouts;

public final class DefaultRolloutsImpl
implements DefaultRollouts {
    private static final ClientLogger LOGGER = new ClientLogger(DefaultRolloutsImpl.class);
    private final DefaultRolloutsClient innerClient;
    private final ProviderHubManager serviceManager;

    public DefaultRolloutsImpl(DefaultRolloutsClient innerClient, ProviderHubManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<DefaultRollout> getWithResponse(String providerNamespace, String rolloutName, Context context) {
        Response<DefaultRolloutInner> inner = this.serviceClient().getWithResponse(providerNamespace, rolloutName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DefaultRolloutImpl((DefaultRolloutInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DefaultRollout get(String providerNamespace, String rolloutName) {
        DefaultRolloutInner inner = this.serviceClient().get(providerNamespace, rolloutName);
        if (inner != null) {
            return new DefaultRolloutImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteByResourceGroupWithResponse(String providerNamespace, String rolloutName, Context context) {
        return this.serviceClient().deleteWithResponse(providerNamespace, rolloutName, context);
    }

    @Override
    public void deleteByResourceGroup(String providerNamespace, String rolloutName) {
        this.serviceClient().delete(providerNamespace, rolloutName);
    }

    @Override
    public PagedIterable<DefaultRollout> listByProviderRegistration(String providerNamespace) {
        PagedIterable<DefaultRolloutInner> inner = this.serviceClient().listByProviderRegistration(providerNamespace);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DefaultRolloutImpl((DefaultRolloutInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DefaultRollout> listByProviderRegistration(String providerNamespace, Context context) {
        PagedIterable<DefaultRolloutInner> inner = this.serviceClient().listByProviderRegistration(providerNamespace, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DefaultRolloutImpl((DefaultRolloutInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Void> stopWithResponse(String providerNamespace, String rolloutName, Context context) {
        return this.serviceClient().stopWithResponse(providerNamespace, rolloutName, context);
    }

    @Override
    public void stop(String providerNamespace, String rolloutName) {
        this.serviceClient().stop(providerNamespace, rolloutName);
    }

    @Override
    public DefaultRollout getById(String id) {
        String providerNamespace = ResourceManagerUtils.getValueFromIdByName(id, "providerRegistrations");
        if (providerNamespace == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'providerRegistrations'.", id)));
        }
        String rolloutName = ResourceManagerUtils.getValueFromIdByName(id, "defaultRollouts");
        if (rolloutName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'defaultRollouts'.", id)));
        }
        return (DefaultRollout)this.getWithResponse(providerNamespace, rolloutName, Context.NONE).getValue();
    }

    @Override
    public Response<DefaultRollout> getByIdWithResponse(String id, Context context) {
        String providerNamespace = ResourceManagerUtils.getValueFromIdByName(id, "providerRegistrations");
        if (providerNamespace == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'providerRegistrations'.", id)));
        }
        String rolloutName = ResourceManagerUtils.getValueFromIdByName(id, "defaultRollouts");
        if (rolloutName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'defaultRollouts'.", id)));
        }
        return this.getWithResponse(providerNamespace, rolloutName, context);
    }

    @Override
    public void deleteById(String id) {
        String providerNamespace = ResourceManagerUtils.getValueFromIdByName(id, "providerRegistrations");
        if (providerNamespace == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'providerRegistrations'.", id)));
        }
        String rolloutName = ResourceManagerUtils.getValueFromIdByName(id, "defaultRollouts");
        if (rolloutName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'defaultRollouts'.", id)));
        }
        this.deleteByResourceGroupWithResponse(providerNamespace, rolloutName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String providerNamespace = ResourceManagerUtils.getValueFromIdByName(id, "providerRegistrations");
        if (providerNamespace == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'providerRegistrations'.", id)));
        }
        String rolloutName = ResourceManagerUtils.getValueFromIdByName(id, "defaultRollouts");
        if (rolloutName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'defaultRollouts'.", id)));
        }
        return this.deleteByResourceGroupWithResponse(providerNamespace, rolloutName, context);
    }

    private DefaultRolloutsClient serviceClient() {
        return this.innerClient;
    }

    private ProviderHubManager manager() {
        return this.serviceManager;
    }

    @Override
    public DefaultRolloutImpl define(String name) {
        return new DefaultRolloutImpl(name, this.manager());
    }
}

