/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.providerhub.ProviderHubManager;
import com.azure.resourcemanager.providerhub.fluent.models.DefaultRolloutInner;
import com.azure.resourcemanager.providerhub.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.providerhub.models.DefaultRollout;
import com.azure.resourcemanager.providerhub.models.DefaultRolloutProperties;

public final class DefaultRolloutImpl
implements DefaultRollout,
DefaultRollout.Definition,
DefaultRollout.Update {
    private DefaultRolloutInner innerObject;
    private final ProviderHubManager serviceManager;
    private String providerNamespace;
    private String rolloutName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public DefaultRolloutProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public DefaultRolloutInner innerModel() {
        return this.innerObject;
    }

    private ProviderHubManager manager() {
        return this.serviceManager;
    }

    @Override
    public DefaultRolloutImpl withExistingProviderRegistration(String providerNamespace) {
        this.providerNamespace = providerNamespace;
        return this;
    }

    @Override
    public DefaultRollout create() {
        this.innerObject = this.serviceManager.serviceClient().getDefaultRollouts().createOrUpdate(this.providerNamespace, this.rolloutName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public DefaultRollout create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDefaultRollouts().createOrUpdate(this.providerNamespace, this.rolloutName, this.innerModel(), context);
        return this;
    }

    DefaultRolloutImpl(String name, ProviderHubManager serviceManager) {
        this.innerObject = new DefaultRolloutInner();
        this.serviceManager = serviceManager;
        this.rolloutName = name;
    }

    @Override
    public DefaultRolloutImpl update() {
        return this;
    }

    @Override
    public DefaultRollout apply() {
        this.innerObject = this.serviceManager.serviceClient().getDefaultRollouts().createOrUpdate(this.providerNamespace, this.rolloutName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public DefaultRollout apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDefaultRollouts().createOrUpdate(this.providerNamespace, this.rolloutName, this.innerModel(), context);
        return this;
    }

    DefaultRolloutImpl(DefaultRolloutInner innerObject, ProviderHubManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.providerNamespace = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "providerRegistrations");
        this.rolloutName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "defaultRollouts");
    }

    @Override
    public DefaultRollout refresh() {
        this.innerObject = (DefaultRolloutInner)((Object)this.serviceManager.serviceClient().getDefaultRollouts().getWithResponse(this.providerNamespace, this.rolloutName, Context.NONE).getValue());
        return this;
    }

    @Override
    public DefaultRollout refresh(Context context) {
        this.innerObject = (DefaultRolloutInner)((Object)this.serviceManager.serviceClient().getDefaultRollouts().getWithResponse(this.providerNamespace, this.rolloutName, context).getValue());
        return this;
    }

    @Override
    public Response<Void> stopWithResponse(Context context) {
        return this.serviceManager.defaultRollouts().stopWithResponse(this.providerNamespace, this.rolloutName, context);
    }

    @Override
    public void stop() {
        this.serviceManager.defaultRollouts().stop(this.providerNamespace, this.rolloutName);
    }

    @Override
    public DefaultRolloutImpl withProperties(DefaultRolloutProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

