/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.providerhub.ProviderHubManager;
import com.azure.resourcemanager.providerhub.fluent.CustomRolloutsClient;
import com.azure.resourcemanager.providerhub.fluent.models.CustomRolloutInner;
import com.azure.resourcemanager.providerhub.implementation.CustomRolloutImpl;
import com.azure.resourcemanager.providerhub.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.providerhub.models.CustomRollout;
import com.azure.resourcemanager.providerhub.models.CustomRollouts;

public final class CustomRolloutsImpl
implements CustomRollouts {
    private static final ClientLogger LOGGER = new ClientLogger(CustomRolloutsImpl.class);
    private final CustomRolloutsClient innerClient;
    private final ProviderHubManager serviceManager;

    public CustomRolloutsImpl(CustomRolloutsClient innerClient, ProviderHubManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<CustomRollout> getWithResponse(String providerNamespace, String rolloutName, Context context) {
        Response<CustomRolloutInner> inner = this.serviceClient().getWithResponse(providerNamespace, rolloutName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CustomRolloutImpl((CustomRolloutInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public CustomRollout get(String providerNamespace, String rolloutName) {
        CustomRolloutInner inner = this.serviceClient().get(providerNamespace, rolloutName);
        if (inner != null) {
            return new CustomRolloutImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteByResourceGroupWithResponse(String providerNamespace, String rolloutName, Context context) {
        return this.serviceClient().deleteWithResponse(providerNamespace, rolloutName, context);
    }

    @Override
    public void deleteByResourceGroup(String providerNamespace, String rolloutName) {
        this.serviceClient().delete(providerNamespace, rolloutName);
    }

    @Override
    public PagedIterable<CustomRollout> listByProviderRegistration(String providerNamespace) {
        PagedIterable<CustomRolloutInner> inner = this.serviceClient().listByProviderRegistration(providerNamespace);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CustomRolloutImpl((CustomRolloutInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<CustomRollout> listByProviderRegistration(String providerNamespace, Context context) {
        PagedIterable<CustomRolloutInner> inner = this.serviceClient().listByProviderRegistration(providerNamespace, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CustomRolloutImpl((CustomRolloutInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Void> stopWithResponse(String providerNamespace, String rolloutName, Context context) {
        return this.serviceClient().stopWithResponse(providerNamespace, rolloutName, context);
    }

    @Override
    public void stop(String providerNamespace, String rolloutName) {
        this.serviceClient().stop(providerNamespace, rolloutName);
    }

    @Override
    public CustomRollout getById(String id) {
        String providerNamespace = ResourceManagerUtils.getValueFromIdByName(id, "providerRegistrations");
        if (providerNamespace == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'providerRegistrations'.", id)));
        }
        String rolloutName = ResourceManagerUtils.getValueFromIdByName(id, "customRollouts");
        if (rolloutName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'customRollouts'.", id)));
        }
        return (CustomRollout)this.getWithResponse(providerNamespace, rolloutName, Context.NONE).getValue();
    }

    @Override
    public Response<CustomRollout> getByIdWithResponse(String id, Context context) {
        String providerNamespace = ResourceManagerUtils.getValueFromIdByName(id, "providerRegistrations");
        if (providerNamespace == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'providerRegistrations'.", id)));
        }
        String rolloutName = ResourceManagerUtils.getValueFromIdByName(id, "customRollouts");
        if (rolloutName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'customRollouts'.", id)));
        }
        return this.getWithResponse(providerNamespace, rolloutName, context);
    }

    @Override
    public void deleteById(String id) {
        String providerNamespace = ResourceManagerUtils.getValueFromIdByName(id, "providerRegistrations");
        if (providerNamespace == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'providerRegistrations'.", id)));
        }
        String rolloutName = ResourceManagerUtils.getValueFromIdByName(id, "customRollouts");
        if (rolloutName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'customRollouts'.", id)));
        }
        this.deleteByResourceGroupWithResponse(providerNamespace, rolloutName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String providerNamespace = ResourceManagerUtils.getValueFromIdByName(id, "providerRegistrations");
        if (providerNamespace == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'providerRegistrations'.", id)));
        }
        String rolloutName = ResourceManagerUtils.getValueFromIdByName(id, "customRollouts");
        if (rolloutName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'customRollouts'.", id)));
        }
        return this.deleteByResourceGroupWithResponse(providerNamespace, rolloutName, context);
    }

    private CustomRolloutsClient serviceClient() {
        return this.innerClient;
    }

    private ProviderHubManager manager() {
        return this.serviceManager;
    }

    @Override
    public CustomRolloutImpl define(String name) {
        return new CustomRolloutImpl(name, this.manager());
    }
}

