/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.providerhub.fluent.CustomRolloutsClient;
import com.azure.resourcemanager.providerhub.fluent.models.CustomRolloutInner;
import com.azure.resourcemanager.providerhub.implementation.ProviderHubImpl;
import com.azure.resourcemanager.providerhub.models.CustomRolloutArrayResponseWithContinuation;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class CustomRolloutsClientImpl
implements CustomRolloutsClient {
    private final CustomRolloutsService service;
    private final ProviderHubImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(CustomRolloutsClientImpl.class);

    CustomRolloutsClientImpl(ProviderHubImpl client) {
        this.service = (CustomRolloutsService)RestProxy.create(CustomRolloutsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CustomRolloutInner>> getWithResponseAsync(String providerNamespace, String rolloutName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (rolloutName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter rolloutName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, rolloutName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CustomRolloutInner> getAsync(String providerNamespace, String rolloutName) {
        return this.getWithResponseAsync(providerNamespace, rolloutName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((CustomRolloutInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CustomRolloutInner> getWithResponse(String providerNamespace, String rolloutName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (rolloutName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter rolloutName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, rolloutName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CustomRolloutInner get(String providerNamespace, String rolloutName) {
        return (CustomRolloutInner)((Object)this.getWithResponse(providerNamespace, rolloutName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String providerNamespace, String rolloutName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (rolloutName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter rolloutName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, rolloutName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String providerNamespace, String rolloutName) {
        return this.deleteWithResponseAsync(providerNamespace, rolloutName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String providerNamespace, String rolloutName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (rolloutName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter rolloutName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, rolloutName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String providerNamespace, String rolloutName) {
        this.deleteWithResponse(providerNamespace, rolloutName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String providerNamespace, String rolloutName, CustomRolloutInner properties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (rolloutName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter rolloutName is required and cannot be null."));
        }
        if (properties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, rolloutName, this.client.getApiVersion(), properties, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String providerNamespace, String rolloutName, CustomRolloutInner properties) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (rolloutName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter rolloutName is required and cannot be null."));
        }
        if (properties == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, rolloutName, this.client.getApiVersion(), properties, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String providerNamespace, String rolloutName, CustomRolloutInner properties, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (rolloutName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter rolloutName is required and cannot be null."));
        }
        if (properties == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, rolloutName, this.client.getApiVersion(), properties, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CustomRolloutInner>, CustomRolloutInner> beginCreateOrUpdateAsync(String providerNamespace, String rolloutName, CustomRolloutInner properties) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(providerNamespace, rolloutName, properties);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)CustomRolloutInner.class), (Type)((Object)CustomRolloutInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CustomRolloutInner>, CustomRolloutInner> beginCreateOrUpdate(String providerNamespace, String rolloutName, CustomRolloutInner properties) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(providerNamespace, rolloutName, properties);
        return this.client.getLroResult(response, (Type)((Object)CustomRolloutInner.class), (Type)((Object)CustomRolloutInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CustomRolloutInner>, CustomRolloutInner> beginCreateOrUpdate(String providerNamespace, String rolloutName, CustomRolloutInner properties, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(providerNamespace, rolloutName, properties, context);
        return this.client.getLroResult(response, (Type)((Object)CustomRolloutInner.class), (Type)((Object)CustomRolloutInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CustomRolloutInner> createOrUpdateAsync(String providerNamespace, String rolloutName, CustomRolloutInner properties) {
        return this.beginCreateOrUpdateAsync(providerNamespace, rolloutName, properties).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CustomRolloutInner createOrUpdate(String providerNamespace, String rolloutName, CustomRolloutInner properties) {
        return (CustomRolloutInner)((Object)this.beginCreateOrUpdate(providerNamespace, rolloutName, properties).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CustomRolloutInner createOrUpdate(String providerNamespace, String rolloutName, CustomRolloutInner properties, Context context) {
        return (CustomRolloutInner)((Object)this.beginCreateOrUpdate(providerNamespace, rolloutName, properties, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CustomRolloutInner>> listByProviderRegistrationSinglePageAsync(String providerNamespace) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByProviderRegistration(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CustomRolloutArrayResponseWithContinuation)res.getValue()).value(), ((CustomRolloutArrayResponseWithContinuation)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<CustomRolloutInner> listByProviderRegistrationAsync(String providerNamespace) {
        return new PagedFlux(() -> this.listByProviderRegistrationSinglePageAsync(providerNamespace), nextLink -> this.listByProviderRegistrationNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<CustomRolloutInner> listByProviderRegistrationSinglePage(String providerNamespace) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        String accept = "application/json";
        Response<CustomRolloutArrayResponseWithContinuation> res = this.service.listByProviderRegistrationSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, this.client.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CustomRolloutArrayResponseWithContinuation)res.getValue()).value(), ((CustomRolloutArrayResponseWithContinuation)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<CustomRolloutInner> listByProviderRegistrationSinglePage(String providerNamespace, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        String accept = "application/json";
        Response<CustomRolloutArrayResponseWithContinuation> res = this.service.listByProviderRegistrationSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CustomRolloutArrayResponseWithContinuation)res.getValue()).value(), ((CustomRolloutArrayResponseWithContinuation)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CustomRolloutInner> listByProviderRegistration(String providerNamespace) {
        return new PagedIterable(() -> this.listByProviderRegistrationSinglePage(providerNamespace), nextLink -> this.listByProviderRegistrationNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CustomRolloutInner> listByProviderRegistration(String providerNamespace, Context context) {
        return new PagedIterable(() -> this.listByProviderRegistrationSinglePage(providerNamespace, context), nextLink -> this.listByProviderRegistrationNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> stopWithResponseAsync(String providerNamespace, String rolloutName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (rolloutName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter rolloutName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.stop(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, rolloutName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> stopAsync(String providerNamespace, String rolloutName) {
        return this.stopWithResponseAsync(providerNamespace, rolloutName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> stopWithResponse(String providerNamespace, String rolloutName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (rolloutName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter rolloutName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.stopSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, rolloutName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stop(String providerNamespace, String rolloutName) {
        this.stopWithResponse(providerNamespace, rolloutName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CustomRolloutInner>> listByProviderRegistrationNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByProviderRegistrationNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CustomRolloutArrayResponseWithContinuation)res.getValue()).value(), ((CustomRolloutArrayResponseWithContinuation)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<CustomRolloutInner> listByProviderRegistrationNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<CustomRolloutArrayResponseWithContinuation> res = this.service.listByProviderRegistrationNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CustomRolloutArrayResponseWithContinuation)res.getValue()).value(), ((CustomRolloutArrayResponseWithContinuation)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<CustomRolloutInner> listByProviderRegistrationNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<CustomRolloutArrayResponseWithContinuation> res = this.service.listByProviderRegistrationNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CustomRolloutArrayResponseWithContinuation)res.getValue()).value(), ((CustomRolloutArrayResponseWithContinuation)res.getValue()).nextLink(), null);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ProviderHubCustomRollouts")
    public static interface CustomRolloutsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/customRollouts/{rolloutName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CustomRolloutInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="rolloutName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/customRollouts/{rolloutName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<CustomRolloutInner> getSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="rolloutName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/customRollouts/{rolloutName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="rolloutName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/customRollouts/{rolloutName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<Void> deleteSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="rolloutName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/customRollouts/{rolloutName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="rolloutName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") CustomRolloutInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/customRollouts/{rolloutName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="rolloutName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") CustomRolloutInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/customRollouts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CustomRolloutArrayResponseWithContinuation>> listByProviderRegistration(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/customRollouts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<CustomRolloutArrayResponseWithContinuation> listByProviderRegistrationSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/customRollouts/{rolloutName}/stop")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> stop(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="rolloutName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/customRollouts/{rolloutName}/stop")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<Void> stopSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="rolloutName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CustomRolloutArrayResponseWithContinuation>> listByProviderRegistrationNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<CustomRolloutArrayResponseWithContinuation> listByProviderRegistrationNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

