/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.providerhub.ProviderHubManager;
import com.azure.resourcemanager.providerhub.fluent.models.CustomRolloutInner;
import com.azure.resourcemanager.providerhub.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.providerhub.models.CustomRollout;
import com.azure.resourcemanager.providerhub.models.CustomRolloutProperties;

public final class CustomRolloutImpl
implements CustomRollout,
CustomRollout.Definition,
CustomRollout.Update {
    private CustomRolloutInner innerObject;
    private final ProviderHubManager serviceManager;
    private String providerNamespace;
    private String rolloutName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public CustomRolloutProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public CustomRolloutInner innerModel() {
        return this.innerObject;
    }

    private ProviderHubManager manager() {
        return this.serviceManager;
    }

    @Override
    public CustomRolloutImpl withExistingProviderRegistration(String providerNamespace) {
        this.providerNamespace = providerNamespace;
        return this;
    }

    @Override
    public CustomRollout create() {
        this.innerObject = this.serviceManager.serviceClient().getCustomRollouts().createOrUpdate(this.providerNamespace, this.rolloutName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public CustomRollout create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getCustomRollouts().createOrUpdate(this.providerNamespace, this.rolloutName, this.innerModel(), context);
        return this;
    }

    CustomRolloutImpl(String name, ProviderHubManager serviceManager) {
        this.innerObject = new CustomRolloutInner();
        this.serviceManager = serviceManager;
        this.rolloutName = name;
    }

    @Override
    public CustomRolloutImpl update() {
        return this;
    }

    @Override
    public CustomRollout apply() {
        this.innerObject = this.serviceManager.serviceClient().getCustomRollouts().createOrUpdate(this.providerNamespace, this.rolloutName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public CustomRollout apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getCustomRollouts().createOrUpdate(this.providerNamespace, this.rolloutName, this.innerModel(), context);
        return this;
    }

    CustomRolloutImpl(CustomRolloutInner innerObject, ProviderHubManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.providerNamespace = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "providerRegistrations");
        this.rolloutName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "customRollouts");
    }

    @Override
    public CustomRollout refresh() {
        this.innerObject = (CustomRolloutInner)((Object)this.serviceManager.serviceClient().getCustomRollouts().getWithResponse(this.providerNamespace, this.rolloutName, Context.NONE).getValue());
        return this;
    }

    @Override
    public CustomRollout refresh(Context context) {
        this.innerObject = (CustomRolloutInner)((Object)this.serviceManager.serviceClient().getCustomRollouts().getWithResponse(this.providerNamespace, this.rolloutName, context).getValue());
        return this;
    }

    @Override
    public Response<Void> stopWithResponse(Context context) {
        return this.serviceManager.customRollouts().stopWithResponse(this.providerNamespace, this.rolloutName, context);
    }

    @Override
    public void stop() {
        this.serviceManager.customRollouts().stop(this.providerNamespace, this.rolloutName);
    }

    @Override
    public CustomRolloutImpl withProperties(CustomRolloutProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

