/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.providerhub.ProviderHubManager;
import com.azure.resourcemanager.providerhub.fluent.AuthorizedApplicationsClient;
import com.azure.resourcemanager.providerhub.fluent.models.AuthorizedApplicationInner;
import com.azure.resourcemanager.providerhub.implementation.AuthorizedApplicationImpl;
import com.azure.resourcemanager.providerhub.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.providerhub.models.AuthorizedApplication;
import com.azure.resourcemanager.providerhub.models.AuthorizedApplications;
import java.util.UUID;

public final class AuthorizedApplicationsImpl
implements AuthorizedApplications {
    private static final ClientLogger LOGGER = new ClientLogger(AuthorizedApplicationsImpl.class);
    private final AuthorizedApplicationsClient innerClient;
    private final ProviderHubManager serviceManager;

    public AuthorizedApplicationsImpl(AuthorizedApplicationsClient innerClient, ProviderHubManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<AuthorizedApplication> getWithResponse(String providerNamespace, UUID applicationId, Context context) {
        Response<AuthorizedApplicationInner> inner = this.serviceClient().getWithResponse(providerNamespace, applicationId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AuthorizedApplicationImpl((AuthorizedApplicationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AuthorizedApplication get(String providerNamespace, UUID applicationId) {
        AuthorizedApplicationInner inner = this.serviceClient().get(providerNamespace, applicationId);
        if (inner != null) {
            return new AuthorizedApplicationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String providerNamespace, UUID applicationId, Context context) {
        return this.serviceClient().deleteWithResponse(providerNamespace, applicationId, context);
    }

    @Override
    public void delete(String providerNamespace, UUID applicationId) {
        this.serviceClient().delete(providerNamespace, applicationId);
    }

    @Override
    public PagedIterable<AuthorizedApplication> list(String providerNamespace) {
        PagedIterable<AuthorizedApplicationInner> inner = this.serviceClient().list(providerNamespace);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AuthorizedApplicationImpl((AuthorizedApplicationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AuthorizedApplication> list(String providerNamespace, Context context) {
        PagedIterable<AuthorizedApplicationInner> inner = this.serviceClient().list(providerNamespace, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AuthorizedApplicationImpl((AuthorizedApplicationInner)((Object)inner1), this.manager()));
    }

    @Override
    public AuthorizedApplication getById(String id) {
        String providerNamespace = ResourceManagerUtils.getValueFromIdByName(id, "providerRegistrations");
        if (providerNamespace == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'providerRegistrations'.", id)));
        }
        String applicationIdLocal = ResourceManagerUtils.getValueFromIdByName(id, "authorizedApplications");
        if (applicationIdLocal == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authorizedApplications'.", id)));
        }
        UUID applicationId = UUID.fromString(applicationIdLocal);
        return (AuthorizedApplication)this.getWithResponse(providerNamespace, applicationId, Context.NONE).getValue();
    }

    @Override
    public Response<AuthorizedApplication> getByIdWithResponse(String id, Context context) {
        String providerNamespace = ResourceManagerUtils.getValueFromIdByName(id, "providerRegistrations");
        if (providerNamespace == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'providerRegistrations'.", id)));
        }
        String applicationIdLocal = ResourceManagerUtils.getValueFromIdByName(id, "authorizedApplications");
        if (applicationIdLocal == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authorizedApplications'.", id)));
        }
        UUID applicationId = UUID.fromString(applicationIdLocal);
        return this.getWithResponse(providerNamespace, applicationId, context);
    }

    @Override
    public void deleteById(String id) {
        String providerNamespace = ResourceManagerUtils.getValueFromIdByName(id, "providerRegistrations");
        if (providerNamespace == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'providerRegistrations'.", id)));
        }
        String applicationIdLocal = ResourceManagerUtils.getValueFromIdByName(id, "authorizedApplications");
        if (applicationIdLocal == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authorizedApplications'.", id)));
        }
        UUID applicationId = UUID.fromString(applicationIdLocal);
        this.deleteWithResponse(providerNamespace, applicationId, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String providerNamespace = ResourceManagerUtils.getValueFromIdByName(id, "providerRegistrations");
        if (providerNamespace == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'providerRegistrations'.", id)));
        }
        String applicationIdLocal = ResourceManagerUtils.getValueFromIdByName(id, "authorizedApplications");
        if (applicationIdLocal == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'authorizedApplications'.", id)));
        }
        UUID applicationId = UUID.fromString(applicationIdLocal);
        return this.deleteWithResponse(providerNamespace, applicationId, context);
    }

    private AuthorizedApplicationsClient serviceClient() {
        return this.innerClient;
    }

    private ProviderHubManager manager() {
        return this.serviceManager;
    }

    @Override
    public AuthorizedApplicationImpl define(UUID name) {
        return new AuthorizedApplicationImpl(name, this.manager());
    }
}

