/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.providerhub.fluent.AuthorizedApplicationsClient;
import com.azure.resourcemanager.providerhub.fluent.models.AuthorizedApplicationInner;
import com.azure.resourcemanager.providerhub.implementation.ProviderHubImpl;
import com.azure.resourcemanager.providerhub.models.AuthorizedApplicationArrayResponseWithContinuation;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.UUID;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class AuthorizedApplicationsClientImpl
implements AuthorizedApplicationsClient {
    private final AuthorizedApplicationsService service;
    private final ProviderHubImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(AuthorizedApplicationsClientImpl.class);

    AuthorizedApplicationsClientImpl(ProviderHubImpl client) {
        this.service = (AuthorizedApplicationsService)RestProxy.create(AuthorizedApplicationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AuthorizedApplicationInner>> getWithResponseAsync(String providerNamespace, UUID applicationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, this.client.getApiVersion(), applicationId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AuthorizedApplicationInner> getAsync(String providerNamespace, UUID applicationId) {
        return this.getWithResponseAsync(providerNamespace, applicationId).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AuthorizedApplicationInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AuthorizedApplicationInner> getWithResponse(String providerNamespace, UUID applicationId, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (applicationId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, this.client.getApiVersion(), applicationId, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AuthorizedApplicationInner get(String providerNamespace, UUID applicationId) {
        return (AuthorizedApplicationInner)((Object)this.getWithResponse(providerNamespace, applicationId, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String providerNamespace, UUID applicationId, AuthorizedApplicationInner properties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (properties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, applicationId, this.client.getApiVersion(), properties, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String providerNamespace, UUID applicationId, AuthorizedApplicationInner properties) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (applicationId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (properties == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, applicationId, this.client.getApiVersion(), properties, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String providerNamespace, UUID applicationId, AuthorizedApplicationInner properties, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (applicationId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (properties == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, applicationId, this.client.getApiVersion(), properties, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AuthorizedApplicationInner>, AuthorizedApplicationInner> beginCreateOrUpdateAsync(String providerNamespace, UUID applicationId, AuthorizedApplicationInner properties) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(providerNamespace, applicationId, properties);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AuthorizedApplicationInner.class), (Type)((Object)AuthorizedApplicationInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AuthorizedApplicationInner>, AuthorizedApplicationInner> beginCreateOrUpdate(String providerNamespace, UUID applicationId, AuthorizedApplicationInner properties) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(providerNamespace, applicationId, properties);
        return this.client.getLroResult(response, (Type)((Object)AuthorizedApplicationInner.class), (Type)((Object)AuthorizedApplicationInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AuthorizedApplicationInner>, AuthorizedApplicationInner> beginCreateOrUpdate(String providerNamespace, UUID applicationId, AuthorizedApplicationInner properties, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(providerNamespace, applicationId, properties, context);
        return this.client.getLroResult(response, (Type)((Object)AuthorizedApplicationInner.class), (Type)((Object)AuthorizedApplicationInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AuthorizedApplicationInner> createOrUpdateAsync(String providerNamespace, UUID applicationId, AuthorizedApplicationInner properties) {
        return this.beginCreateOrUpdateAsync(providerNamespace, applicationId, properties).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AuthorizedApplicationInner createOrUpdate(String providerNamespace, UUID applicationId, AuthorizedApplicationInner properties) {
        return (AuthorizedApplicationInner)((Object)this.beginCreateOrUpdate(providerNamespace, applicationId, properties).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AuthorizedApplicationInner createOrUpdate(String providerNamespace, UUID applicationId, AuthorizedApplicationInner properties, Context context) {
        return (AuthorizedApplicationInner)((Object)this.beginCreateOrUpdate(providerNamespace, applicationId, properties, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String providerNamespace, UUID applicationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, this.client.getApiVersion(), applicationId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String providerNamespace, UUID applicationId) {
        return this.deleteWithResponseAsync(providerNamespace, applicationId).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String providerNamespace, UUID applicationId, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        if (applicationId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, this.client.getApiVersion(), applicationId, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String providerNamespace, UUID applicationId) {
        this.deleteWithResponse(providerNamespace, applicationId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AuthorizedApplicationInner>> listSinglePageAsync(String providerNamespace) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AuthorizedApplicationArrayResponseWithContinuation)res.getValue()).value(), ((AuthorizedApplicationArrayResponseWithContinuation)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AuthorizedApplicationInner> listAsync(String providerNamespace) {
        return new PagedFlux(() -> this.listSinglePageAsync(providerNamespace), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AuthorizedApplicationInner> listSinglePage(String providerNamespace) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        String accept = "application/json";
        Response<AuthorizedApplicationArrayResponseWithContinuation> res = this.service.listSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, this.client.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AuthorizedApplicationArrayResponseWithContinuation)res.getValue()).value(), ((AuthorizedApplicationArrayResponseWithContinuation)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AuthorizedApplicationInner> listSinglePage(String providerNamespace, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (providerNamespace == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter providerNamespace is required and cannot be null."));
        }
        String accept = "application/json";
        Response<AuthorizedApplicationArrayResponseWithContinuation> res = this.service.listSync(this.client.getEndpoint(), this.client.getSubscriptionId(), providerNamespace, this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AuthorizedApplicationArrayResponseWithContinuation)res.getValue()).value(), ((AuthorizedApplicationArrayResponseWithContinuation)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AuthorizedApplicationInner> list(String providerNamespace) {
        return new PagedIterable(() -> this.listSinglePage(providerNamespace), nextLink -> this.listNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AuthorizedApplicationInner> list(String providerNamespace, Context context) {
        return new PagedIterable(() -> this.listSinglePage(providerNamespace, context), nextLink -> this.listNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AuthorizedApplicationInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AuthorizedApplicationArrayResponseWithContinuation)res.getValue()).value(), ((AuthorizedApplicationArrayResponseWithContinuation)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AuthorizedApplicationInner> listNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<AuthorizedApplicationArrayResponseWithContinuation> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AuthorizedApplicationArrayResponseWithContinuation)res.getValue()).value(), ((AuthorizedApplicationArrayResponseWithContinuation)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AuthorizedApplicationInner> listNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<AuthorizedApplicationArrayResponseWithContinuation> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AuthorizedApplicationArrayResponseWithContinuation)res.getValue()).value(), ((AuthorizedApplicationArrayResponseWithContinuation)res.getValue()).nextLink(), null);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ProviderHubAuthorizedApplications")
    public static interface AuthorizedApplicationsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/authorizedApplications/{applicationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AuthorizedApplicationInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="applicationId") UUID var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/authorizedApplications/{applicationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<AuthorizedApplicationInner> getSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="applicationId") UUID var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/authorizedApplications/{applicationId}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="applicationId") UUID var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") AuthorizedApplicationInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/authorizedApplications/{applicationId}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @PathParam(value="applicationId") UUID var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") AuthorizedApplicationInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/authorizedApplications/{applicationId}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="applicationId") UUID var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/authorizedApplications/{applicationId}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<Void> deleteSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="applicationId") UUID var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/authorizedApplications")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AuthorizedApplicationArrayResponseWithContinuation>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/authorizedApplications")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<AuthorizedApplicationArrayResponseWithContinuation> listSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="providerNamespace") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AuthorizedApplicationArrayResponseWithContinuation>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<AuthorizedApplicationArrayResponseWithContinuation> listNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

