/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.providerhub.ProviderHubManager;
import com.azure.resourcemanager.providerhub.fluent.models.AuthorizedApplicationInner;
import com.azure.resourcemanager.providerhub.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.providerhub.models.AuthorizedApplication;
import com.azure.resourcemanager.providerhub.models.AuthorizedApplicationProperties;
import java.util.UUID;

public final class AuthorizedApplicationImpl
implements AuthorizedApplication,
AuthorizedApplication.Definition,
AuthorizedApplication.Update {
    private AuthorizedApplicationInner innerObject;
    private final ProviderHubManager serviceManager;
    private String providerNamespace;
    private UUID applicationId;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public AuthorizedApplicationProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public AuthorizedApplicationInner innerModel() {
        return this.innerObject;
    }

    private ProviderHubManager manager() {
        return this.serviceManager;
    }

    @Override
    public AuthorizedApplicationImpl withExistingProviderRegistration(String providerNamespace) {
        this.providerNamespace = providerNamespace;
        return this;
    }

    @Override
    public AuthorizedApplication create() {
        this.innerObject = this.serviceManager.serviceClient().getAuthorizedApplications().createOrUpdate(this.providerNamespace, this.applicationId, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public AuthorizedApplication create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAuthorizedApplications().createOrUpdate(this.providerNamespace, this.applicationId, this.innerModel(), context);
        return this;
    }

    AuthorizedApplicationImpl(UUID name, ProviderHubManager serviceManager) {
        this.innerObject = new AuthorizedApplicationInner();
        this.serviceManager = serviceManager;
        this.applicationId = name;
    }

    @Override
    public AuthorizedApplicationImpl update() {
        return this;
    }

    @Override
    public AuthorizedApplication apply() {
        this.innerObject = this.serviceManager.serviceClient().getAuthorizedApplications().createOrUpdate(this.providerNamespace, this.applicationId, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public AuthorizedApplication apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAuthorizedApplications().createOrUpdate(this.providerNamespace, this.applicationId, this.innerModel(), context);
        return this;
    }

    AuthorizedApplicationImpl(AuthorizedApplicationInner innerObject, ProviderHubManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.providerNamespace = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "providerRegistrations");
        this.applicationId = UUID.fromString(ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "authorizedApplications"));
    }

    @Override
    public AuthorizedApplication refresh() {
        this.innerObject = (AuthorizedApplicationInner)((Object)this.serviceManager.serviceClient().getAuthorizedApplications().getWithResponse(this.providerNamespace, this.applicationId, Context.NONE).getValue());
        return this;
    }

    @Override
    public AuthorizedApplication refresh(Context context) {
        this.innerObject = (AuthorizedApplicationInner)((Object)this.serviceManager.serviceClient().getAuthorizedApplications().getWithResponse(this.providerNamespace, this.applicationId, context).getValue());
        return this;
    }

    @Override
    public AuthorizedApplicationImpl withProperties(AuthorizedApplicationProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

