/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.ResourceTypeRegistrationKind;
import com.azure.resourcemanager.providerhub.models.ResourceTypeRegistrationProperties;
import java.io.IOException;

public final class ResourceTypeRegistrationInner
extends ProxyResource {
    private ResourceTypeRegistrationProperties properties;
    private ResourceTypeRegistrationKind kind;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public ResourceTypeRegistrationProperties properties() {
        return this.properties;
    }

    public ResourceTypeRegistrationInner withProperties(ResourceTypeRegistrationProperties properties) {
        this.properties = properties;
        return this;
    }

    public ResourceTypeRegistrationKind kind() {
        return this.kind;
    }

    public ResourceTypeRegistrationInner withKind(ResourceTypeRegistrationKind kind) {
        this.kind = kind;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResourceTypeRegistrationInner fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceTypeRegistrationInner)((Object)jsonReader.readObject(reader -> {
            ResourceTypeRegistrationInner deserializedResourceTypeRegistrationInner = new ResourceTypeRegistrationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedResourceTypeRegistrationInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedResourceTypeRegistrationInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedResourceTypeRegistrationInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedResourceTypeRegistrationInner.properties = ResourceTypeRegistrationProperties.fromJson(reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedResourceTypeRegistrationInner.kind = ResourceTypeRegistrationKind.fromString(reader.getString());
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedResourceTypeRegistrationInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceTypeRegistrationInner;
        }));
    }
}

