/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.CrossTenantTokenValidation;
import com.azure.resourcemanager.providerhub.models.FanoutLinkedNotificationRule;
import com.azure.resourcemanager.providerhub.models.Notification;
import com.azure.resourcemanager.providerhub.models.ResourceProviderAuthorization;
import com.azure.resourcemanager.providerhub.models.ResourceProviderAuthorizationRules;
import com.azure.resourcemanager.providerhub.models.ResourceProviderCapabilities;
import com.azure.resourcemanager.providerhub.models.ResourceProviderEndpoint;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManifestFeaturesRule;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManifestManagement;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManifestProviderAuthentication;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManifestReRegisterSubscriptionMetadata;
import com.azure.resourcemanager.providerhub.models.ResourceProviderManifestRequestHeaderOptions;
import com.azure.resourcemanager.providerhub.models.ResourceProviderService;
import com.azure.resourcemanager.providerhub.models.ResourceProviderType;
import com.azure.resourcemanager.providerhub.models.ResourceType;
import java.io.IOException;
import java.util.List;

public final class ResourceProviderManifestInner
implements JsonSerializable<ResourceProviderManifestInner> {
    private ResourceProviderManifestProviderAuthentication providerAuthentication;
    private List<ResourceProviderAuthorization> providerAuthorizations;
    private String namespace;
    private List<ResourceProviderService> services;
    private String serviceName;
    private String providerVersion;
    private ResourceProviderType providerType;
    private List<String> requiredFeatures;
    private ResourceProviderManifestFeaturesRule featuresRule;
    private ResourceProviderManifestRequestHeaderOptions requestHeaderOptions;
    private List<ResourceType> resourceTypes;
    private ResourceProviderManifestManagement management;
    private List<ResourceProviderCapabilities> capabilities;
    private CrossTenantTokenValidation crossTenantTokenValidation;
    private Object metadata;
    private List<ResourceProviderEndpoint> globalNotificationEndpoints;
    private ResourceProviderManifestReRegisterSubscriptionMetadata reRegisterSubscriptionMetadata;
    private Boolean enableTenantLinkedNotification;
    private List<Notification> notifications;
    private List<FanoutLinkedNotificationRule> linkedNotificationRules;
    private ResourceProviderAuthorizationRules resourceProviderAuthorizationRules;

    public ResourceProviderManifestProviderAuthentication providerAuthentication() {
        return this.providerAuthentication;
    }

    public ResourceProviderManifestInner withProviderAuthentication(ResourceProviderManifestProviderAuthentication providerAuthentication) {
        this.providerAuthentication = providerAuthentication;
        return this;
    }

    public List<ResourceProviderAuthorization> providerAuthorizations() {
        return this.providerAuthorizations;
    }

    public ResourceProviderManifestInner withProviderAuthorizations(List<ResourceProviderAuthorization> providerAuthorizations) {
        this.providerAuthorizations = providerAuthorizations;
        return this;
    }

    public String namespace() {
        return this.namespace;
    }

    public ResourceProviderManifestInner withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public List<ResourceProviderService> services() {
        return this.services;
    }

    public ResourceProviderManifestInner withServices(List<ResourceProviderService> services) {
        this.services = services;
        return this;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public ResourceProviderManifestInner withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public String providerVersion() {
        return this.providerVersion;
    }

    public ResourceProviderManifestInner withProviderVersion(String providerVersion) {
        this.providerVersion = providerVersion;
        return this;
    }

    public ResourceProviderType providerType() {
        return this.providerType;
    }

    public ResourceProviderManifestInner withProviderType(ResourceProviderType providerType) {
        this.providerType = providerType;
        return this;
    }

    public List<String> requiredFeatures() {
        return this.requiredFeatures;
    }

    public ResourceProviderManifestInner withRequiredFeatures(List<String> requiredFeatures) {
        this.requiredFeatures = requiredFeatures;
        return this;
    }

    public ResourceProviderManifestFeaturesRule featuresRule() {
        return this.featuresRule;
    }

    public ResourceProviderManifestInner withFeaturesRule(ResourceProviderManifestFeaturesRule featuresRule) {
        this.featuresRule = featuresRule;
        return this;
    }

    public ResourceProviderManifestRequestHeaderOptions requestHeaderOptions() {
        return this.requestHeaderOptions;
    }

    public ResourceProviderManifestInner withRequestHeaderOptions(ResourceProviderManifestRequestHeaderOptions requestHeaderOptions) {
        this.requestHeaderOptions = requestHeaderOptions;
        return this;
    }

    public List<ResourceType> resourceTypes() {
        return this.resourceTypes;
    }

    public ResourceProviderManifestInner withResourceTypes(List<ResourceType> resourceTypes) {
        this.resourceTypes = resourceTypes;
        return this;
    }

    public ResourceProviderManifestManagement management() {
        return this.management;
    }

    public ResourceProviderManifestInner withManagement(ResourceProviderManifestManagement management) {
        this.management = management;
        return this;
    }

    public List<ResourceProviderCapabilities> capabilities() {
        return this.capabilities;
    }

    public ResourceProviderManifestInner withCapabilities(List<ResourceProviderCapabilities> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public CrossTenantTokenValidation crossTenantTokenValidation() {
        return this.crossTenantTokenValidation;
    }

    public ResourceProviderManifestInner withCrossTenantTokenValidation(CrossTenantTokenValidation crossTenantTokenValidation) {
        this.crossTenantTokenValidation = crossTenantTokenValidation;
        return this;
    }

    public Object metadata() {
        return this.metadata;
    }

    public ResourceProviderManifestInner withMetadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<ResourceProviderEndpoint> globalNotificationEndpoints() {
        return this.globalNotificationEndpoints;
    }

    public ResourceProviderManifestInner withGlobalNotificationEndpoints(List<ResourceProviderEndpoint> globalNotificationEndpoints) {
        this.globalNotificationEndpoints = globalNotificationEndpoints;
        return this;
    }

    public ResourceProviderManifestReRegisterSubscriptionMetadata reRegisterSubscriptionMetadata() {
        return this.reRegisterSubscriptionMetadata;
    }

    public ResourceProviderManifestInner withReRegisterSubscriptionMetadata(ResourceProviderManifestReRegisterSubscriptionMetadata reRegisterSubscriptionMetadata) {
        this.reRegisterSubscriptionMetadata = reRegisterSubscriptionMetadata;
        return this;
    }

    public Boolean enableTenantLinkedNotification() {
        return this.enableTenantLinkedNotification;
    }

    public ResourceProviderManifestInner withEnableTenantLinkedNotification(Boolean enableTenantLinkedNotification) {
        this.enableTenantLinkedNotification = enableTenantLinkedNotification;
        return this;
    }

    public List<Notification> notifications() {
        return this.notifications;
    }

    public ResourceProviderManifestInner withNotifications(List<Notification> notifications) {
        this.notifications = notifications;
        return this;
    }

    public List<FanoutLinkedNotificationRule> linkedNotificationRules() {
        return this.linkedNotificationRules;
    }

    public ResourceProviderManifestInner withLinkedNotificationRules(List<FanoutLinkedNotificationRule> linkedNotificationRules) {
        this.linkedNotificationRules = linkedNotificationRules;
        return this;
    }

    public ResourceProviderAuthorizationRules resourceProviderAuthorizationRules() {
        return this.resourceProviderAuthorizationRules;
    }

    public ResourceProviderManifestInner withResourceProviderAuthorizationRules(ResourceProviderAuthorizationRules resourceProviderAuthorizationRules) {
        this.resourceProviderAuthorizationRules = resourceProviderAuthorizationRules;
        return this;
    }

    public void validate() {
        if (this.providerAuthentication() != null) {
            this.providerAuthentication().validate();
        }
        if (this.providerAuthorizations() != null) {
            this.providerAuthorizations().forEach(e -> e.validate());
        }
        if (this.services() != null) {
            this.services().forEach(e -> e.validate());
        }
        if (this.featuresRule() != null) {
            this.featuresRule().validate();
        }
        if (this.requestHeaderOptions() != null) {
            this.requestHeaderOptions().validate();
        }
        if (this.resourceTypes() != null) {
            this.resourceTypes().forEach(e -> e.validate());
        }
        if (this.management() != null) {
            this.management().validate();
        }
        if (this.capabilities() != null) {
            this.capabilities().forEach(e -> e.validate());
        }
        if (this.globalNotificationEndpoints() != null) {
            this.globalNotificationEndpoints().forEach(e -> e.validate());
        }
        if (this.reRegisterSubscriptionMetadata() != null) {
            this.reRegisterSubscriptionMetadata().validate();
        }
        if (this.notifications() != null) {
            this.notifications().forEach(e -> e.validate());
        }
        if (this.linkedNotificationRules() != null) {
            this.linkedNotificationRules().forEach(e -> e.validate());
        }
        if (this.resourceProviderAuthorizationRules() != null) {
            this.resourceProviderAuthorizationRules().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("providerAuthentication", (JsonSerializable)this.providerAuthentication);
        jsonWriter.writeArrayField("providerAuthorizations", this.providerAuthorizations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("namespace", this.namespace);
        jsonWriter.writeArrayField("services", this.services, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("serviceName", this.serviceName);
        jsonWriter.writeStringField("providerVersion", this.providerVersion);
        jsonWriter.writeStringField("providerType", this.providerType == null ? null : this.providerType.toString());
        jsonWriter.writeArrayField("requiredFeatures", this.requiredFeatures, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("featuresRule", (JsonSerializable)this.featuresRule);
        jsonWriter.writeJsonField("requestHeaderOptions", (JsonSerializable)this.requestHeaderOptions);
        jsonWriter.writeArrayField("resourceTypes", this.resourceTypes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("management", (JsonSerializable)this.management);
        jsonWriter.writeArrayField("capabilities", this.capabilities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("crossTenantTokenValidation", this.crossTenantTokenValidation == null ? null : this.crossTenantTokenValidation.toString());
        if (this.metadata != null) {
            jsonWriter.writeUntypedField("metadata", this.metadata);
        }
        jsonWriter.writeArrayField("globalNotificationEndpoints", this.globalNotificationEndpoints, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("reRegisterSubscriptionMetadata", (JsonSerializable)this.reRegisterSubscriptionMetadata);
        jsonWriter.writeBooleanField("enableTenantLinkedNotification", this.enableTenantLinkedNotification);
        jsonWriter.writeArrayField("notifications", this.notifications, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("linkedNotificationRules", this.linkedNotificationRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("resourceProviderAuthorizationRules", (JsonSerializable)this.resourceProviderAuthorizationRules);
        return jsonWriter.writeEndObject();
    }

    public static ResourceProviderManifestInner fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceProviderManifestInner)jsonReader.readObject(reader -> {
            ResourceProviderManifestInner deserializedResourceProviderManifestInner = new ResourceProviderManifestInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("providerAuthentication".equals(fieldName)) {
                    deserializedResourceProviderManifestInner.providerAuthentication = ResourceProviderManifestProviderAuthentication.fromJson(reader);
                    continue;
                }
                if ("providerAuthorizations".equals(fieldName)) {
                    List providerAuthorizations;
                    deserializedResourceProviderManifestInner.providerAuthorizations = providerAuthorizations = reader.readArray(reader1 -> ResourceProviderAuthorization.fromJson(reader1));
                    continue;
                }
                if ("namespace".equals(fieldName)) {
                    deserializedResourceProviderManifestInner.namespace = reader.getString();
                    continue;
                }
                if ("services".equals(fieldName)) {
                    List services;
                    deserializedResourceProviderManifestInner.services = services = reader.readArray(reader1 -> ResourceProviderService.fromJson(reader1));
                    continue;
                }
                if ("serviceName".equals(fieldName)) {
                    deserializedResourceProviderManifestInner.serviceName = reader.getString();
                    continue;
                }
                if ("providerVersion".equals(fieldName)) {
                    deserializedResourceProviderManifestInner.providerVersion = reader.getString();
                    continue;
                }
                if ("providerType".equals(fieldName)) {
                    deserializedResourceProviderManifestInner.providerType = ResourceProviderType.fromString(reader.getString());
                    continue;
                }
                if ("requiredFeatures".equals(fieldName)) {
                    List requiredFeatures;
                    deserializedResourceProviderManifestInner.requiredFeatures = requiredFeatures = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("featuresRule".equals(fieldName)) {
                    deserializedResourceProviderManifestInner.featuresRule = ResourceProviderManifestFeaturesRule.fromJson(reader);
                    continue;
                }
                if ("requestHeaderOptions".equals(fieldName)) {
                    deserializedResourceProviderManifestInner.requestHeaderOptions = ResourceProviderManifestRequestHeaderOptions.fromJson(reader);
                    continue;
                }
                if ("resourceTypes".equals(fieldName)) {
                    List resourceTypes;
                    deserializedResourceProviderManifestInner.resourceTypes = resourceTypes = reader.readArray(reader1 -> ResourceType.fromJson(reader1));
                    continue;
                }
                if ("management".equals(fieldName)) {
                    deserializedResourceProviderManifestInner.management = ResourceProviderManifestManagement.fromJson(reader);
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    List capabilities;
                    deserializedResourceProviderManifestInner.capabilities = capabilities = reader.readArray(reader1 -> ResourceProviderCapabilities.fromJson(reader1));
                    continue;
                }
                if ("crossTenantTokenValidation".equals(fieldName)) {
                    deserializedResourceProviderManifestInner.crossTenantTokenValidation = CrossTenantTokenValidation.fromString(reader.getString());
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    deserializedResourceProviderManifestInner.metadata = reader.readUntyped();
                    continue;
                }
                if ("globalNotificationEndpoints".equals(fieldName)) {
                    List globalNotificationEndpoints;
                    deserializedResourceProviderManifestInner.globalNotificationEndpoints = globalNotificationEndpoints = reader.readArray(reader1 -> ResourceProviderEndpoint.fromJson(reader1));
                    continue;
                }
                if ("reRegisterSubscriptionMetadata".equals(fieldName)) {
                    deserializedResourceProviderManifestInner.reRegisterSubscriptionMetadata = ResourceProviderManifestReRegisterSubscriptionMetadata.fromJson(reader);
                    continue;
                }
                if ("enableTenantLinkedNotification".equals(fieldName)) {
                    deserializedResourceProviderManifestInner.enableTenantLinkedNotification = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("notifications".equals(fieldName)) {
                    List notifications;
                    deserializedResourceProviderManifestInner.notifications = notifications = reader.readArray(reader1 -> Notification.fromJson(reader1));
                    continue;
                }
                if ("linkedNotificationRules".equals(fieldName)) {
                    List linkedNotificationRules;
                    deserializedResourceProviderManifestInner.linkedNotificationRules = linkedNotificationRules = reader.readArray(reader1 -> FanoutLinkedNotificationRule.fromJson(reader1));
                    continue;
                }
                if ("resourceProviderAuthorizationRules".equals(fieldName)) {
                    deserializedResourceProviderManifestInner.resourceProviderAuthorizationRules = ResourceProviderAuthorizationRules.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceProviderManifestInner;
        });
    }
}

