/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.ProviderRegistrationKind;
import com.azure.resourcemanager.providerhub.models.ProviderRegistrationProperties;
import java.io.IOException;

public class ProviderRegistrationInner
extends ProxyResource {
    private ProviderRegistrationProperties properties;
    private ProviderRegistrationKind kind;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public ProviderRegistrationProperties properties() {
        return this.properties;
    }

    public ProviderRegistrationInner withProperties(ProviderRegistrationProperties properties) {
        this.properties = properties;
        return this;
    }

    public ProviderRegistrationKind kind() {
        return this.kind;
    }

    public ProviderRegistrationInner withKind(ProviderRegistrationKind kind) {
        this.kind = kind;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    ProviderRegistrationInner withSystemData(SystemData systemData) {
        this.systemData = systemData;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    public static ProviderRegistrationInner fromJson(JsonReader jsonReader) throws IOException {
        return (ProviderRegistrationInner)((Object)jsonReader.readObject(reader -> {
            ProviderRegistrationInner deserializedProviderRegistrationInner = new ProviderRegistrationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedProviderRegistrationInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedProviderRegistrationInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedProviderRegistrationInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedProviderRegistrationInner.properties = ProviderRegistrationProperties.fromJson(reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedProviderRegistrationInner.kind = ProviderRegistrationKind.fromString(reader.getString());
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedProviderRegistrationInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProviderRegistrationInner;
        }));
    }
}

