/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.ProviderMonitorSettingProperties;
import java.io.IOException;
import java.util.Map;

public final class ProviderMonitorSettingInner
extends Resource {
    private ProviderMonitorSettingProperties properties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public ProviderMonitorSettingProperties properties() {
        return this.properties;
    }

    public ProviderMonitorSettingInner withProperties(ProviderMonitorSettingProperties properties) {
        this.properties = properties;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ProviderMonitorSettingInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ProviderMonitorSettingInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static ProviderMonitorSettingInner fromJson(JsonReader jsonReader) throws IOException {
        return (ProviderMonitorSettingInner)((Object)jsonReader.readObject(reader -> {
            ProviderMonitorSettingInner deserializedProviderMonitorSettingInner = new ProviderMonitorSettingInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedProviderMonitorSettingInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedProviderMonitorSettingInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedProviderMonitorSettingInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedProviderMonitorSettingInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedProviderMonitorSettingInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedProviderMonitorSettingInner.properties = ProviderMonitorSettingProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedProviderMonitorSettingInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProviderMonitorSettingInner;
        }));
    }
}

