/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.OperationActionType;
import com.azure.resourcemanager.providerhub.models.OperationOrigins;
import com.azure.resourcemanager.providerhub.models.OperationsDefinitionDisplay;
import java.io.IOException;

public final class OperationsDefinitionInner
implements JsonSerializable<OperationsDefinitionInner> {
    private String name;
    private Boolean isDataAction;
    private OperationOrigins origin;
    private OperationsDefinitionDisplay display;
    private OperationActionType actionType;
    private Object properties;
    private static final ClientLogger LOGGER = new ClientLogger(OperationsDefinitionInner.class);

    public String name() {
        return this.name;
    }

    public OperationsDefinitionInner withName(String name) {
        this.name = name;
        return this;
    }

    public Boolean isDataAction() {
        return this.isDataAction;
    }

    public OperationsDefinitionInner withIsDataAction(Boolean isDataAction) {
        this.isDataAction = isDataAction;
        return this;
    }

    public OperationOrigins origin() {
        return this.origin;
    }

    public OperationsDefinitionInner withOrigin(OperationOrigins origin) {
        this.origin = origin;
        return this;
    }

    public OperationsDefinitionDisplay display() {
        return this.display;
    }

    public OperationsDefinitionInner withDisplay(OperationsDefinitionDisplay display) {
        this.display = display;
        return this;
    }

    public OperationActionType actionType() {
        return this.actionType;
    }

    public OperationsDefinitionInner withActionType(OperationActionType actionType) {
        this.actionType = actionType;
        return this;
    }

    public Object properties() {
        return this.properties;
    }

    public OperationsDefinitionInner withProperties(Object properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model OperationsDefinitionInner"));
        }
        if (this.display() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property display in model OperationsDefinitionInner"));
        }
        this.display().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("display", (JsonSerializable)this.display);
        jsonWriter.writeBooleanField("isDataAction", this.isDataAction);
        jsonWriter.writeStringField("origin", this.origin == null ? null : this.origin.toString());
        jsonWriter.writeStringField("actionType", this.actionType == null ? null : this.actionType.toString());
        if (this.properties != null) {
            jsonWriter.writeUntypedField("properties", this.properties);
        }
        return jsonWriter.writeEndObject();
    }

    public static OperationsDefinitionInner fromJson(JsonReader jsonReader) throws IOException {
        return (OperationsDefinitionInner)jsonReader.readObject(reader -> {
            OperationsDefinitionInner deserializedOperationsDefinitionInner = new OperationsDefinitionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedOperationsDefinitionInner.name = reader.getString();
                    continue;
                }
                if ("display".equals(fieldName)) {
                    deserializedOperationsDefinitionInner.display = OperationsDefinitionDisplay.fromJson(reader);
                    continue;
                }
                if ("isDataAction".equals(fieldName)) {
                    deserializedOperationsDefinitionInner.isDataAction = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("origin".equals(fieldName)) {
                    deserializedOperationsDefinitionInner.origin = OperationOrigins.fromString(reader.getString());
                    continue;
                }
                if ("actionType".equals(fieldName)) {
                    deserializedOperationsDefinitionInner.actionType = OperationActionType.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedOperationsDefinitionInner.properties = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationsDefinitionInner;
        });
    }
}

