/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.providerhub.models.CustomRolloutProperties;
import java.io.IOException;

public final class CustomRolloutInner
extends ProxyResource {
    private CustomRolloutProperties properties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(CustomRolloutInner.class);

    public CustomRolloutProperties properties() {
        return this.properties;
    }

    public CustomRolloutInner withProperties(CustomRolloutProperties properties) {
        this.properties = properties;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model CustomRolloutInner"));
        }
        this.properties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static CustomRolloutInner fromJson(JsonReader jsonReader) throws IOException {
        return (CustomRolloutInner)((Object)jsonReader.readObject(reader -> {
            CustomRolloutInner deserializedCustomRolloutInner = new CustomRolloutInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCustomRolloutInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCustomRolloutInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCustomRolloutInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCustomRolloutInner.properties = CustomRolloutProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedCustomRolloutInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomRolloutInner;
        }));
    }
}

