/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.providerhub;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.providerhub.fluent.ProviderHub;
import com.azure.resourcemanager.providerhub.implementation.AuthorizedApplicationsImpl;
import com.azure.resourcemanager.providerhub.implementation.CustomRolloutsImpl;
import com.azure.resourcemanager.providerhub.implementation.DefaultRolloutsImpl;
import com.azure.resourcemanager.providerhub.implementation.NewRegionFrontloadReleasesImpl;
import com.azure.resourcemanager.providerhub.implementation.NotificationRegistrationsImpl;
import com.azure.resourcemanager.providerhub.implementation.OperationsImpl;
import com.azure.resourcemanager.providerhub.implementation.ProviderHubBuilder;
import com.azure.resourcemanager.providerhub.implementation.ProviderMonitorSettingsImpl;
import com.azure.resourcemanager.providerhub.implementation.ProviderRegistrationsImpl;
import com.azure.resourcemanager.providerhub.implementation.ResourceActionsImpl;
import com.azure.resourcemanager.providerhub.implementation.ResourceProvidersImpl;
import com.azure.resourcemanager.providerhub.implementation.ResourceTypeRegistrationsImpl;
import com.azure.resourcemanager.providerhub.implementation.SkusImpl;
import com.azure.resourcemanager.providerhub.models.AuthorizedApplications;
import com.azure.resourcemanager.providerhub.models.CustomRollouts;
import com.azure.resourcemanager.providerhub.models.DefaultRollouts;
import com.azure.resourcemanager.providerhub.models.NewRegionFrontloadReleases;
import com.azure.resourcemanager.providerhub.models.NotificationRegistrations;
import com.azure.resourcemanager.providerhub.models.Operations;
import com.azure.resourcemanager.providerhub.models.ProviderMonitorSettings;
import com.azure.resourcemanager.providerhub.models.ProviderRegistrations;
import com.azure.resourcemanager.providerhub.models.ResourceActions;
import com.azure.resourcemanager.providerhub.models.ResourceProviders;
import com.azure.resourcemanager.providerhub.models.ResourceTypeRegistrations;
import com.azure.resourcemanager.providerhub.models.Skus;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class ProviderHubManager {
    private CustomRollouts customRollouts;
    private DefaultRollouts defaultRollouts;
    private ResourceProviders resourceProviders;
    private NotificationRegistrations notificationRegistrations;
    private Operations operations;
    private ProviderRegistrations providerRegistrations;
    private ResourceTypeRegistrations resourceTypeRegistrations;
    private Skus skus;
    private ResourceActions resourceActions;
    private AuthorizedApplications authorizedApplications;
    private ProviderMonitorSettings providerMonitorSettings;
    private NewRegionFrontloadReleases newRegionFrontloadReleases;
    private final ProviderHub clientObject;

    private ProviderHubManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject = new ProviderHubBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).defaultPollInterval(defaultPollInterval).buildClient();
    }

    public static ProviderHubManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return ProviderHubManager.configure().authenticate(credential, profile);
    }

    public static ProviderHubManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new ProviderHubManager(httpPipeline, profile, null);
    }

    public static Configurable configure() {
        return new Configurable();
    }

    public CustomRollouts customRollouts() {
        if (this.customRollouts == null) {
            this.customRollouts = new CustomRolloutsImpl(this.clientObject.getCustomRollouts(), this);
        }
        return this.customRollouts;
    }

    public DefaultRollouts defaultRollouts() {
        if (this.defaultRollouts == null) {
            this.defaultRollouts = new DefaultRolloutsImpl(this.clientObject.getDefaultRollouts(), this);
        }
        return this.defaultRollouts;
    }

    public ResourceProviders resourceProviders() {
        if (this.resourceProviders == null) {
            this.resourceProviders = new ResourceProvidersImpl(this.clientObject.getResourceProviders(), this);
        }
        return this.resourceProviders;
    }

    public NotificationRegistrations notificationRegistrations() {
        if (this.notificationRegistrations == null) {
            this.notificationRegistrations = new NotificationRegistrationsImpl(this.clientObject.getNotificationRegistrations(), this);
        }
        return this.notificationRegistrations;
    }

    public Operations operations() {
        if (this.operations == null) {
            this.operations = new OperationsImpl(this.clientObject.getOperations(), this);
        }
        return this.operations;
    }

    public ProviderRegistrations providerRegistrations() {
        if (this.providerRegistrations == null) {
            this.providerRegistrations = new ProviderRegistrationsImpl(this.clientObject.getProviderRegistrations(), this);
        }
        return this.providerRegistrations;
    }

    public ResourceTypeRegistrations resourceTypeRegistrations() {
        if (this.resourceTypeRegistrations == null) {
            this.resourceTypeRegistrations = new ResourceTypeRegistrationsImpl(this.clientObject.getResourceTypeRegistrations(), this);
        }
        return this.resourceTypeRegistrations;
    }

    public Skus skus() {
        if (this.skus == null) {
            this.skus = new SkusImpl(this.clientObject.getSkus(), this);
        }
        return this.skus;
    }

    public ResourceActions resourceActions() {
        if (this.resourceActions == null) {
            this.resourceActions = new ResourceActionsImpl(this.clientObject.getResourceActions(), this);
        }
        return this.resourceActions;
    }

    public AuthorizedApplications authorizedApplications() {
        if (this.authorizedApplications == null) {
            this.authorizedApplications = new AuthorizedApplicationsImpl(this.clientObject.getAuthorizedApplications(), this);
        }
        return this.authorizedApplications;
    }

    public ProviderMonitorSettings providerMonitorSettings() {
        if (this.providerMonitorSettings == null) {
            this.providerMonitorSettings = new ProviderMonitorSettingsImpl(this.clientObject.getProviderMonitorSettings(), this);
        }
        return this.providerMonitorSettings;
    }

    public NewRegionFrontloadReleases newRegionFrontloadReleases() {
        if (this.newRegionFrontloadReleases == null) {
            this.newRegionFrontloadReleases = new NewRegionFrontloadReleasesImpl(this.clientObject.getNewRegionFrontloadReleases(), this);
        }
        return this.newRegionFrontloadReleases;
    }

    public ProviderHub serviceClient() {
        return this.clientObject;
    }

    public static final class Configurable {
        private static final ClientLogger LOGGER = new ClientLogger(Configurable.class);
        private static final String SDK_VERSION = "version";
        private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-resourcemanager-providerhub.properties");
        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        private final List<String> scopes = new ArrayList<String>();
        private RetryPolicy retryPolicy;
        private RetryOptions retryOptions;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        public Configurable withScope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope, "'scope' cannot be null."));
            return this;
        }

        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        public Configurable withRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
            return this;
        }

        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval = Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'defaultPollInterval' cannot be negative"));
            }
            return this;
        }

        public ProviderHubManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");
            String clientVersion = PROPERTIES.getOrDefault(SDK_VERSION, "UnknownVersion");
            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("azsdk-java").append("-").append("com.azure.resourcemanager.providerhub").append("/").append(clientVersion);
            if (!((Boolean)Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", (Object)false)).booleanValue()) {
                userAgentBuilder.append(" (").append(Configuration.getGlobalConfiguration().get("java.version")).append("; ").append(Configuration.getGlobalConfiguration().get("os.name")).append("; ").append(Configuration.getGlobalConfiguration().get("os.version")).append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }
            if (this.scopes.isEmpty()) {
                this.scopes.add(profile.getEnvironment().getManagementEndpoint() + "/.default");
            }
            if (this.retryPolicy == null) {
                this.retryPolicy = this.retryOptions != null ? new RetryPolicy(this.retryOptions) : new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
            }
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new AddHeadersFromContextPolicy());
            policies.add(new RequestIdPolicy());
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(this.retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new BearerTokenAuthenticationPolicy(credential, this.scopes.toArray(new String[0])));
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(this.httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
            return new ProviderHubManager(httpPipeline, profile, this.defaultPollInterval);
        }
    }
}

