/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ValidationMessage;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ValidationState;
import java.io.IOException;
import java.util.List;

public final class ValidationSummaryItem
implements JsonSerializable<ValidationSummaryItem> {
    private String type;
    private ValidationState state;
    private List<ValidationMessage> messages;

    public String type() {
        return this.type;
    }

    public ValidationSummaryItem withType(String type) {
        this.type = type;
        return this;
    }

    public ValidationState state() {
        return this.state;
    }

    public ValidationSummaryItem withState(ValidationState state) {
        this.state = state;
        return this;
    }

    public List<ValidationMessage> messages() {
        return this.messages;
    }

    public ValidationSummaryItem withMessages(List<ValidationMessage> messages) {
        this.messages = messages;
        return this;
    }

    public void validate() {
        if (this.messages() != null) {
            this.messages().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeArrayField("messages", this.messages, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ValidationSummaryItem fromJson(JsonReader jsonReader) throws IOException {
        return (ValidationSummaryItem)jsonReader.readObject(reader -> {
            ValidationSummaryItem deserializedValidationSummaryItem = new ValidationSummaryItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedValidationSummaryItem.type = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedValidationSummaryItem.state = ValidationState.fromString(reader.getString());
                    continue;
                }
                if ("messages".equals(fieldName)) {
                    List messages;
                    deserializedValidationSummaryItem.messages = messages = reader.readArray(reader1 -> ValidationMessage.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedValidationSummaryItem;
        });
    }
}

