/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CapabilityBase;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CapabilityStatus;
import com.azure.resourcemanager.postgresqlflexibleserver.models.SupportedFeature;
import java.io.IOException;
import java.util.List;

public final class ServerVersionCapability
extends CapabilityBase {
    private String name;
    private List<String> supportedVersionsToUpgrade;
    private List<SupportedFeature> supportedFeatures;
    private String reason;
    private CapabilityStatus status;

    public String name() {
        return this.name;
    }

    public List<String> supportedVersionsToUpgrade() {
        return this.supportedVersionsToUpgrade;
    }

    public List<SupportedFeature> supportedFeatures() {
        return this.supportedFeatures;
    }

    @Override
    public String reason() {
        return this.reason;
    }

    @Override
    public CapabilityStatus status() {
        return this.status;
    }

    @Override
    public void validate() {
        if (this.supportedFeatures() != null) {
            this.supportedFeatures().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ServerVersionCapability fromJson(JsonReader jsonReader) throws IOException {
        return (ServerVersionCapability)jsonReader.readObject(reader -> {
            ServerVersionCapability deserializedServerVersionCapability = new ServerVersionCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedServerVersionCapability.status = CapabilityStatus.fromString(reader.getString());
                    continue;
                }
                if ("reason".equals(fieldName)) {
                    deserializedServerVersionCapability.reason = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedServerVersionCapability.name = reader.getString();
                    continue;
                }
                if ("supportedVersionsToUpgrade".equals(fieldName)) {
                    List supportedVersionsToUpgrade;
                    deserializedServerVersionCapability.supportedVersionsToUpgrade = supportedVersionsToUpgrade = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("supportedFeatures".equals(fieldName)) {
                    List supportedFeatures;
                    deserializedServerVersionCapability.supportedFeatures = supportedFeatures = reader.readArray(reader1 -> SupportedFeature.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerVersionCapability;
        });
    }
}

