/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class AdminCredentials
implements JsonSerializable<AdminCredentials> {
    private String sourceServerPassword;
    private String targetServerPassword;
    private static final ClientLogger LOGGER = new ClientLogger(AdminCredentials.class);

    public String sourceServerPassword() {
        return this.sourceServerPassword;
    }

    public AdminCredentials withSourceServerPassword(String sourceServerPassword) {
        this.sourceServerPassword = sourceServerPassword;
        return this;
    }

    public String targetServerPassword() {
        return this.targetServerPassword;
    }

    public AdminCredentials withTargetServerPassword(String targetServerPassword) {
        this.targetServerPassword = targetServerPassword;
        return this;
    }

    public void validate() {
        if (this.sourceServerPassword() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceServerPassword in model AdminCredentials"));
        }
        if (this.targetServerPassword() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetServerPassword in model AdminCredentials"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceServerPassword", this.sourceServerPassword);
        jsonWriter.writeStringField("targetServerPassword", this.targetServerPassword);
        return jsonWriter.writeEndObject();
    }

    public static AdminCredentials fromJson(JsonReader jsonReader) throws IOException {
        return (AdminCredentials)jsonReader.readObject(reader -> {
            AdminCredentials deserializedAdminCredentials = new AdminCredentials();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceServerPassword".equals(fieldName)) {
                    deserializedAdminCredentials.sourceServerPassword = reader.getString();
                    continue;
                }
                if ("targetServerPassword".equals(fieldName)) {
                    deserializedAdminCredentials.targetServerPassword = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAdminCredentials;
        });
    }
}

