/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.ServerInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.PrivateEndpointConnectionImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.postgresqlflexibleserver.models.AuthConfig;
import com.azure.resourcemanager.postgresqlflexibleserver.models.AuthConfigForPatch;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Backup;
import com.azure.resourcemanager.postgresqlflexibleserver.models.BackupForPatch;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Cluster;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CreateMode;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CreateModeForPatch;
import com.azure.resourcemanager.postgresqlflexibleserver.models.DataEncryption;
import com.azure.resourcemanager.postgresqlflexibleserver.models.HighAvailability;
import com.azure.resourcemanager.postgresqlflexibleserver.models.HighAvailabilityForPatch;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MaintenanceWindow;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MaintenanceWindowForPatch;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Network;
import com.azure.resourcemanager.postgresqlflexibleserver.models.PostgresMajorVersion;
import com.azure.resourcemanager.postgresqlflexibleserver.models.PrivateEndpointConnection;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Replica;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ReplicationRole;
import com.azure.resourcemanager.postgresqlflexibleserver.models.RestartParameter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Server;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerForPatch;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerState;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Sku;
import com.azure.resourcemanager.postgresqlflexibleserver.models.SkuForPatch;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Storage;
import com.azure.resourcemanager.postgresqlflexibleserver.models.UserAssignedIdentity;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class ServerImpl
implements Server,
Server.Definition,
Server.Update {
    private ServerInner innerObject;
    private final PostgreSqlManager serviceManager;
    private String resourceGroupName;
    private String serverName;
    private ServerForPatch updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public Sku sku() {
        return this.innerModel().sku();
    }

    @Override
    public UserAssignedIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String administratorLogin() {
        return this.innerModel().administratorLogin();
    }

    @Override
    public String administratorLoginPassword() {
        return this.innerModel().administratorLoginPassword();
    }

    @Override
    public PostgresMajorVersion version() {
        return this.innerModel().version();
    }

    @Override
    public String minorVersion() {
        return this.innerModel().minorVersion();
    }

    @Override
    public ServerState state() {
        return this.innerModel().state();
    }

    @Override
    public String fullyQualifiedDomainName() {
        return this.innerModel().fullyQualifiedDomainName();
    }

    @Override
    public Storage storage() {
        return this.innerModel().storage();
    }

    @Override
    public AuthConfig authConfig() {
        return this.innerModel().authConfig();
    }

    @Override
    public DataEncryption dataEncryption() {
        return this.innerModel().dataEncryption();
    }

    @Override
    public Backup backup() {
        return this.innerModel().backup();
    }

    @Override
    public Network network() {
        return this.innerModel().network();
    }

    @Override
    public HighAvailability highAvailability() {
        return this.innerModel().highAvailability();
    }

    @Override
    public MaintenanceWindow maintenanceWindow() {
        return this.innerModel().maintenanceWindow();
    }

    @Override
    public String sourceServerResourceId() {
        return this.innerModel().sourceServerResourceId();
    }

    @Override
    public OffsetDateTime pointInTimeUtc() {
        return this.innerModel().pointInTimeUtc();
    }

    @Override
    public String availabilityZone() {
        return this.innerModel().availabilityZone();
    }

    @Override
    public ReplicationRole replicationRole() {
        return this.innerModel().replicationRole();
    }

    @Override
    public Integer replicaCapacity() {
        return this.innerModel().replicaCapacity();
    }

    @Override
    public Replica replica() {
        return this.innerModel().replica();
    }

    @Override
    public CreateMode createMode() {
        return this.innerModel().createMode();
    }

    @Override
    public List<PrivateEndpointConnection> privateEndpointConnections() {
        List<PrivateEndpointConnectionInner> inner = this.innerModel().privateEndpointConnections();
        if (inner != null) {
            return Collections.unmodifiableList(inner.stream().map(inner1 -> new PrivateEndpointConnectionImpl((PrivateEndpointConnectionInner)((Object)inner1), this.manager())).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    @Override
    public Cluster cluster() {
        return this.innerModel().cluster();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ServerInner innerModel() {
        return this.innerObject;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public ServerImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Server create() {
        this.innerObject = this.serviceManager.serviceClient().getServers().createOrUpdate(this.resourceGroupName, this.serverName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Server create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getServers().createOrUpdate(this.resourceGroupName, this.serverName, this.innerModel(), context);
        return this;
    }

    ServerImpl(String name, PostgreSqlManager serviceManager) {
        this.innerObject = new ServerInner();
        this.serviceManager = serviceManager;
        this.serverName = name;
    }

    @Override
    public ServerImpl update() {
        this.updateParameters = new ServerForPatch();
        return this;
    }

    @Override
    public Server apply() {
        this.innerObject = this.serviceManager.serviceClient().getServers().update(this.resourceGroupName, this.serverName, this.updateParameters, Context.NONE);
        return this;
    }

    @Override
    public Server apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getServers().update(this.resourceGroupName, this.serverName, this.updateParameters, context);
        return this;
    }

    ServerImpl(ServerInner innerObject, PostgreSqlManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serverName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "flexibleServers");
    }

    @Override
    public Server refresh() {
        this.innerObject = (ServerInner)((Object)this.serviceManager.serviceClient().getServers().getByResourceGroupWithResponse(this.resourceGroupName, this.serverName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Server refresh(Context context) {
        this.innerObject = (ServerInner)((Object)this.serviceManager.serviceClient().getServers().getByResourceGroupWithResponse(this.resourceGroupName, this.serverName, context).getValue());
        return this;
    }

    @Override
    public void restart() {
        this.serviceManager.servers().restart(this.resourceGroupName, this.serverName);
    }

    @Override
    public void restart(RestartParameter parameters, Context context) {
        this.serviceManager.servers().restart(this.resourceGroupName, this.serverName, parameters, context);
    }

    @Override
    public void start() {
        this.serviceManager.servers().start(this.resourceGroupName, this.serverName);
    }

    @Override
    public void start(Context context) {
        this.serviceManager.servers().start(this.resourceGroupName, this.serverName, context);
    }

    @Override
    public void stop() {
        this.serviceManager.servers().stop(this.resourceGroupName, this.serverName);
    }

    @Override
    public void stop(Context context) {
        this.serviceManager.servers().stop(this.resourceGroupName, this.serverName, context);
    }

    @Override
    public ServerImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ServerImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ServerImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    @Override
    public ServerImpl withSku(Sku sku) {
        this.innerModel().withSku(sku);
        return this;
    }

    @Override
    public ServerImpl withIdentity(UserAssignedIdentity identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateParameters.withIdentity(identity);
        return this;
    }

    @Override
    public ServerImpl withAdministratorLogin(String administratorLogin) {
        this.innerModel().withAdministratorLogin(administratorLogin);
        return this;
    }

    @Override
    public ServerImpl withAdministratorLoginPassword(String administratorLoginPassword) {
        if (this.isInCreateMode()) {
            this.innerModel().withAdministratorLoginPassword(administratorLoginPassword);
            return this;
        }
        this.updateParameters.withAdministratorLoginPassword(administratorLoginPassword);
        return this;
    }

    @Override
    public ServerImpl withVersion(PostgresMajorVersion version) {
        if (this.isInCreateMode()) {
            this.innerModel().withVersion(version);
            return this;
        }
        this.updateParameters.withVersion(version);
        return this;
    }

    @Override
    public ServerImpl withStorage(Storage storage) {
        if (this.isInCreateMode()) {
            this.innerModel().withStorage(storage);
            return this;
        }
        this.updateParameters.withStorage(storage);
        return this;
    }

    @Override
    public ServerImpl withAuthConfig(AuthConfig authConfig) {
        this.innerModel().withAuthConfig(authConfig);
        return this;
    }

    @Override
    public ServerImpl withDataEncryption(DataEncryption dataEncryption) {
        if (this.isInCreateMode()) {
            this.innerModel().withDataEncryption(dataEncryption);
            return this;
        }
        this.updateParameters.withDataEncryption(dataEncryption);
        return this;
    }

    @Override
    public ServerImpl withBackup(Backup backup) {
        this.innerModel().withBackup(backup);
        return this;
    }

    @Override
    public ServerImpl withNetwork(Network network) {
        if (this.isInCreateMode()) {
            this.innerModel().withNetwork(network);
            return this;
        }
        this.updateParameters.withNetwork(network);
        return this;
    }

    @Override
    public ServerImpl withHighAvailability(HighAvailability highAvailability) {
        this.innerModel().withHighAvailability(highAvailability);
        return this;
    }

    @Override
    public ServerImpl withSourceServerResourceId(String sourceServerResourceId) {
        this.innerModel().withSourceServerResourceId(sourceServerResourceId);
        return this;
    }

    @Override
    public ServerImpl withPointInTimeUtc(OffsetDateTime pointInTimeUtc) {
        this.innerModel().withPointInTimeUtc(pointInTimeUtc);
        return this;
    }

    @Override
    public ServerImpl withAvailabilityZone(String availabilityZone) {
        if (this.isInCreateMode()) {
            this.innerModel().withAvailabilityZone(availabilityZone);
            return this;
        }
        this.updateParameters.withAvailabilityZone(availabilityZone);
        return this;
    }

    @Override
    public ServerImpl withReplicationRole(ReplicationRole replicationRole) {
        if (this.isInCreateMode()) {
            this.innerModel().withReplicationRole(replicationRole);
            return this;
        }
        this.updateParameters.withReplicationRole(replicationRole);
        return this;
    }

    @Override
    public ServerImpl withCreateMode(CreateMode createMode) {
        this.innerModel().withCreateMode(createMode);
        return this;
    }

    @Override
    public ServerImpl withCluster(Cluster cluster) {
        if (this.isInCreateMode()) {
            this.innerModel().withCluster(cluster);
            return this;
        }
        this.updateParameters.withCluster(cluster);
        return this;
    }

    @Override
    public ServerImpl withSku(SkuForPatch sku) {
        this.updateParameters.withSku(sku);
        return this;
    }

    @Override
    public ServerImpl withBackup(BackupForPatch backup) {
        this.updateParameters.withBackup(backup);
        return this;
    }

    @Override
    public ServerImpl withHighAvailability(HighAvailabilityForPatch highAvailability) {
        this.updateParameters.withHighAvailability(highAvailability);
        return this;
    }

    @Override
    public ServerImpl withMaintenanceWindow(MaintenanceWindowForPatch maintenanceWindow) {
        this.updateParameters.withMaintenanceWindow(maintenanceWindow);
        return this;
    }

    @Override
    public ServerImpl withAuthConfig(AuthConfigForPatch authConfig) {
        this.updateParameters.withAuthConfig(authConfig);
        return this;
    }

    @Override
    public ServerImpl withCreateMode(CreateModeForPatch createMode) {
        this.updateParameters.withCreateMode(createMode);
        return this;
    }

    @Override
    public ServerImpl withReplica(Replica replica) {
        this.updateParameters.withReplica(replica);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

