/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.AuthConfigForPatch;
import com.azure.resourcemanager.postgresqlflexibleserver.models.BackupForPatch;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Cluster;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CreateModeForPatch;
import com.azure.resourcemanager.postgresqlflexibleserver.models.DataEncryption;
import com.azure.resourcemanager.postgresqlflexibleserver.models.HighAvailabilityForPatch;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MaintenanceWindowForPatch;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Network;
import com.azure.resourcemanager.postgresqlflexibleserver.models.PostgresMajorVersion;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Replica;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ReplicationRole;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Storage;
import java.io.IOException;

public final class ServerPropertiesForPatch
implements JsonSerializable<ServerPropertiesForPatch> {
    private String administratorLogin;
    private String administratorLoginPassword;
    private PostgresMajorVersion version;
    private Storage storage;
    private BackupForPatch backup;
    private HighAvailabilityForPatch highAvailability;
    private MaintenanceWindowForPatch maintenanceWindow;
    private AuthConfigForPatch authConfig;
    private DataEncryption dataEncryption;
    private String availabilityZone;
    private CreateModeForPatch createMode;
    private ReplicationRole replicationRole;
    private Replica replica;
    private Network network;
    private Cluster cluster;

    public String administratorLogin() {
        return this.administratorLogin;
    }

    public ServerPropertiesForPatch withAdministratorLogin(String administratorLogin) {
        this.administratorLogin = administratorLogin;
        return this;
    }

    public String administratorLoginPassword() {
        return this.administratorLoginPassword;
    }

    public ServerPropertiesForPatch withAdministratorLoginPassword(String administratorLoginPassword) {
        this.administratorLoginPassword = administratorLoginPassword;
        return this;
    }

    public PostgresMajorVersion version() {
        return this.version;
    }

    public ServerPropertiesForPatch withVersion(PostgresMajorVersion version) {
        this.version = version;
        return this;
    }

    public Storage storage() {
        return this.storage;
    }

    public ServerPropertiesForPatch withStorage(Storage storage) {
        this.storage = storage;
        return this;
    }

    public BackupForPatch backup() {
        return this.backup;
    }

    public ServerPropertiesForPatch withBackup(BackupForPatch backup) {
        this.backup = backup;
        return this;
    }

    public HighAvailabilityForPatch highAvailability() {
        return this.highAvailability;
    }

    public ServerPropertiesForPatch withHighAvailability(HighAvailabilityForPatch highAvailability) {
        this.highAvailability = highAvailability;
        return this;
    }

    public MaintenanceWindowForPatch maintenanceWindow() {
        return this.maintenanceWindow;
    }

    public ServerPropertiesForPatch withMaintenanceWindow(MaintenanceWindowForPatch maintenanceWindow) {
        this.maintenanceWindow = maintenanceWindow;
        return this;
    }

    public AuthConfigForPatch authConfig() {
        return this.authConfig;
    }

    public ServerPropertiesForPatch withAuthConfig(AuthConfigForPatch authConfig) {
        this.authConfig = authConfig;
        return this;
    }

    public DataEncryption dataEncryption() {
        return this.dataEncryption;
    }

    public ServerPropertiesForPatch withDataEncryption(DataEncryption dataEncryption) {
        this.dataEncryption = dataEncryption;
        return this;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public ServerPropertiesForPatch withAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public CreateModeForPatch createMode() {
        return this.createMode;
    }

    public ServerPropertiesForPatch withCreateMode(CreateModeForPatch createMode) {
        this.createMode = createMode;
        return this;
    }

    public ReplicationRole replicationRole() {
        return this.replicationRole;
    }

    public ServerPropertiesForPatch withReplicationRole(ReplicationRole replicationRole) {
        this.replicationRole = replicationRole;
        return this;
    }

    public Replica replica() {
        return this.replica;
    }

    public ServerPropertiesForPatch withReplica(Replica replica) {
        this.replica = replica;
        return this;
    }

    public Network network() {
        return this.network;
    }

    public ServerPropertiesForPatch withNetwork(Network network) {
        this.network = network;
        return this;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public ServerPropertiesForPatch withCluster(Cluster cluster) {
        this.cluster = cluster;
        return this;
    }

    public void validate() {
        if (this.storage() != null) {
            this.storage().validate();
        }
        if (this.backup() != null) {
            this.backup().validate();
        }
        if (this.highAvailability() != null) {
            this.highAvailability().validate();
        }
        if (this.maintenanceWindow() != null) {
            this.maintenanceWindow().validate();
        }
        if (this.authConfig() != null) {
            this.authConfig().validate();
        }
        if (this.dataEncryption() != null) {
            this.dataEncryption().validate();
        }
        if (this.replica() != null) {
            this.replica().validate();
        }
        if (this.network() != null) {
            this.network().validate();
        }
        if (this.cluster() != null) {
            this.cluster().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("administratorLogin", this.administratorLogin);
        jsonWriter.writeStringField("administratorLoginPassword", this.administratorLoginPassword);
        jsonWriter.writeStringField("version", this.version == null ? null : this.version.toString());
        jsonWriter.writeJsonField("storage", (JsonSerializable)this.storage);
        jsonWriter.writeJsonField("backup", (JsonSerializable)this.backup);
        jsonWriter.writeJsonField("highAvailability", (JsonSerializable)this.highAvailability);
        jsonWriter.writeJsonField("maintenanceWindow", (JsonSerializable)this.maintenanceWindow);
        jsonWriter.writeJsonField("authConfig", (JsonSerializable)this.authConfig);
        jsonWriter.writeJsonField("dataEncryption", (JsonSerializable)this.dataEncryption);
        jsonWriter.writeStringField("availabilityZone", this.availabilityZone);
        jsonWriter.writeStringField("createMode", this.createMode == null ? null : this.createMode.toString());
        jsonWriter.writeStringField("replicationRole", this.replicationRole == null ? null : this.replicationRole.toString());
        jsonWriter.writeJsonField("replica", (JsonSerializable)this.replica);
        jsonWriter.writeJsonField("network", (JsonSerializable)this.network);
        jsonWriter.writeJsonField("cluster", (JsonSerializable)this.cluster);
        return jsonWriter.writeEndObject();
    }

    public static ServerPropertiesForPatch fromJson(JsonReader jsonReader) throws IOException {
        return (ServerPropertiesForPatch)jsonReader.readObject(reader -> {
            ServerPropertiesForPatch deserializedServerPropertiesForPatch = new ServerPropertiesForPatch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("administratorLogin".equals(fieldName)) {
                    deserializedServerPropertiesForPatch.administratorLogin = reader.getString();
                    continue;
                }
                if ("administratorLoginPassword".equals(fieldName)) {
                    deserializedServerPropertiesForPatch.administratorLoginPassword = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedServerPropertiesForPatch.version = PostgresMajorVersion.fromString(reader.getString());
                    continue;
                }
                if ("storage".equals(fieldName)) {
                    deserializedServerPropertiesForPatch.storage = Storage.fromJson(reader);
                    continue;
                }
                if ("backup".equals(fieldName)) {
                    deserializedServerPropertiesForPatch.backup = BackupForPatch.fromJson(reader);
                    continue;
                }
                if ("highAvailability".equals(fieldName)) {
                    deserializedServerPropertiesForPatch.highAvailability = HighAvailabilityForPatch.fromJson(reader);
                    continue;
                }
                if ("maintenanceWindow".equals(fieldName)) {
                    deserializedServerPropertiesForPatch.maintenanceWindow = MaintenanceWindowForPatch.fromJson(reader);
                    continue;
                }
                if ("authConfig".equals(fieldName)) {
                    deserializedServerPropertiesForPatch.authConfig = AuthConfigForPatch.fromJson(reader);
                    continue;
                }
                if ("dataEncryption".equals(fieldName)) {
                    deserializedServerPropertiesForPatch.dataEncryption = DataEncryption.fromJson(reader);
                    continue;
                }
                if ("availabilityZone".equals(fieldName)) {
                    deserializedServerPropertiesForPatch.availabilityZone = reader.getString();
                    continue;
                }
                if ("createMode".equals(fieldName)) {
                    deserializedServerPropertiesForPatch.createMode = CreateModeForPatch.fromString(reader.getString());
                    continue;
                }
                if ("replicationRole".equals(fieldName)) {
                    deserializedServerPropertiesForPatch.replicationRole = ReplicationRole.fromString(reader.getString());
                    continue;
                }
                if ("replica".equals(fieldName)) {
                    deserializedServerPropertiesForPatch.replica = Replica.fromJson(reader);
                    continue;
                }
                if ("network".equals(fieldName)) {
                    deserializedServerPropertiesForPatch.network = Network.fromJson(reader);
                    continue;
                }
                if ("cluster".equals(fieldName)) {
                    deserializedServerPropertiesForPatch.cluster = Cluster.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerPropertiesForPatch;
        });
    }
}

