/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CapabilityBase;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CapabilityStatus;
import com.azure.resourcemanager.postgresqlflexibleserver.models.StorageTierCapability;
import java.io.IOException;
import java.util.List;

public final class StorageMbCapability
extends CapabilityBase {
    private Integer supportedIops;
    private Integer supportedMaximumIops;
    private Long storageSizeMb;
    private Long maximumStorageSizeMb;
    private Integer supportedThroughput;
    private Integer supportedMaximumThroughput;
    private String defaultIopsTier;
    private List<StorageTierCapability> supportedIopsTiers;
    private String reason;
    private CapabilityStatus status;

    public Integer supportedIops() {
        return this.supportedIops;
    }

    public Integer supportedMaximumIops() {
        return this.supportedMaximumIops;
    }

    public Long storageSizeMb() {
        return this.storageSizeMb;
    }

    public Long maximumStorageSizeMb() {
        return this.maximumStorageSizeMb;
    }

    public Integer supportedThroughput() {
        return this.supportedThroughput;
    }

    public Integer supportedMaximumThroughput() {
        return this.supportedMaximumThroughput;
    }

    public String defaultIopsTier() {
        return this.defaultIopsTier;
    }

    public List<StorageTierCapability> supportedIopsTiers() {
        return this.supportedIopsTiers;
    }

    @Override
    public String reason() {
        return this.reason;
    }

    @Override
    public CapabilityStatus status() {
        return this.status;
    }

    @Override
    public void validate() {
        if (this.supportedIopsTiers() != null) {
            this.supportedIopsTiers().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static StorageMbCapability fromJson(JsonReader jsonReader) throws IOException {
        return (StorageMbCapability)jsonReader.readObject(reader -> {
            StorageMbCapability deserializedStorageMbCapability = new StorageMbCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedStorageMbCapability.status = CapabilityStatus.fromString(reader.getString());
                    continue;
                }
                if ("reason".equals(fieldName)) {
                    deserializedStorageMbCapability.reason = reader.getString();
                    continue;
                }
                if ("supportedIops".equals(fieldName)) {
                    deserializedStorageMbCapability.supportedIops = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("supportedMaximumIops".equals(fieldName)) {
                    deserializedStorageMbCapability.supportedMaximumIops = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("storageSizeMb".equals(fieldName)) {
                    deserializedStorageMbCapability.storageSizeMb = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("maximumStorageSizeMb".equals(fieldName)) {
                    deserializedStorageMbCapability.maximumStorageSizeMb = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("supportedThroughput".equals(fieldName)) {
                    deserializedStorageMbCapability.supportedThroughput = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("supportedMaximumThroughput".equals(fieldName)) {
                    deserializedStorageMbCapability.supportedMaximumThroughput = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("defaultIopsTier".equals(fieldName)) {
                    deserializedStorageMbCapability.defaultIopsTier = reader.getString();
                    continue;
                }
                if ("supportedIopsTiers".equals(fieldName)) {
                    List supportedIopsTiers;
                    deserializedStorageMbCapability.supportedIopsTiers = supportedIopsTiers = reader.readArray(reader1 -> StorageTierCapability.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageMbCapability;
        });
    }
}

