/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.ServerInner;
import com.azure.resourcemanager.postgresqlflexibleserver.models.AuthConfig;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Backup;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Cluster;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CreateMode;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CreateModeForUpdate;
import com.azure.resourcemanager.postgresqlflexibleserver.models.DataEncryption;
import com.azure.resourcemanager.postgresqlflexibleserver.models.HighAvailability;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MaintenanceWindow;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Network;
import com.azure.resourcemanager.postgresqlflexibleserver.models.PrivateEndpointConnection;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Replica;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ReplicationRole;
import com.azure.resourcemanager.postgresqlflexibleserver.models.RestartParameter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerState;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerVersion;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Sku;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Storage;
import com.azure.resourcemanager.postgresqlflexibleserver.models.UserAssignedIdentity;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public interface Server {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public Sku sku();

    public UserAssignedIdentity identity();

    public SystemData systemData();

    public String administratorLogin();

    public String administratorLoginPassword();

    public ServerVersion version();

    public String minorVersion();

    public ServerState state();

    public String fullyQualifiedDomainName();

    public Storage storage();

    public AuthConfig authConfig();

    public DataEncryption dataEncryption();

    public Backup backup();

    public Network network();

    public HighAvailability highAvailability();

    public MaintenanceWindow maintenanceWindow();

    public String sourceServerResourceId();

    public OffsetDateTime pointInTimeUtc();

    public String availabilityZone();

    public ReplicationRole replicationRole();

    public Integer replicaCapacity();

    public Replica replica();

    public CreateMode createMode();

    public List<PrivateEndpointConnection> privateEndpointConnections();

    public Cluster cluster();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public ServerInner innerModel();

    public Update update();

    public Server refresh();

    public Server refresh(Context var1);

    public void restart();

    public void restart(RestartParameter var1, Context var2);

    public void start();

    public void start(Context var1);

    public void stop();

    public void stop(Context var1);

    public static interface UpdateStages {

        public static interface WithCluster {
            public Update withCluster(Cluster var1);
        }

        public static interface WithNetwork {
            public Update withNetwork(Network var1);
        }

        public static interface WithReplica {
            public Update withReplica(Replica var1);
        }

        public static interface WithReplicationRole {
            public Update withReplicationRole(ReplicationRole var1);
        }

        public static interface WithCreateMode {
            public Update withCreateMode(CreateModeForUpdate var1);
        }

        public static interface WithDataEncryption {
            public Update withDataEncryption(DataEncryption var1);
        }

        public static interface WithAuthConfig {
            public Update withAuthConfig(AuthConfig var1);
        }

        public static interface WithMaintenanceWindow {
            public Update withMaintenanceWindow(MaintenanceWindow var1);
        }

        public static interface WithHighAvailability {
            public Update withHighAvailability(HighAvailability var1);
        }

        public static interface WithBackup {
            public Update withBackup(Backup var1);
        }

        public static interface WithStorage {
            public Update withStorage(Storage var1);
        }

        public static interface WithVersion {
            public Update withVersion(ServerVersion var1);
        }

        public static interface WithAdministratorLoginPassword {
            public Update withAdministratorLoginPassword(String var1);
        }

        public static interface WithAdministratorLogin {
            public Update withAdministratorLogin(String var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(UserAssignedIdentity var1);
        }

        public static interface WithSku {
            public Update withSku(Sku var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithSku,
    UpdateStages.WithIdentity,
    UpdateStages.WithAdministratorLogin,
    UpdateStages.WithAdministratorLoginPassword,
    UpdateStages.WithVersion,
    UpdateStages.WithStorage,
    UpdateStages.WithBackup,
    UpdateStages.WithHighAvailability,
    UpdateStages.WithMaintenanceWindow,
    UpdateStages.WithAuthConfig,
    UpdateStages.WithDataEncryption,
    UpdateStages.WithCreateMode,
    UpdateStages.WithReplicationRole,
    UpdateStages.WithReplica,
    UpdateStages.WithNetwork,
    UpdateStages.WithCluster {
        public Server apply();

        public Server apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithCluster {
            public WithCreate withCluster(Cluster var1);
        }

        public static interface WithCreateMode {
            public WithCreate withCreateMode(CreateMode var1);
        }

        public static interface WithReplicationRole {
            public WithCreate withReplicationRole(ReplicationRole var1);
        }

        public static interface WithAvailabilityZone {
            public WithCreate withAvailabilityZone(String var1);
        }

        public static interface WithPointInTimeUtc {
            public WithCreate withPointInTimeUtc(OffsetDateTime var1);
        }

        public static interface WithSourceServerResourceId {
            public WithCreate withSourceServerResourceId(String var1);
        }

        public static interface WithHighAvailability {
            public WithCreate withHighAvailability(HighAvailability var1);
        }

        public static interface WithNetwork {
            public WithCreate withNetwork(Network var1);
        }

        public static interface WithBackup {
            public WithCreate withBackup(Backup var1);
        }

        public static interface WithDataEncryption {
            public WithCreate withDataEncryption(DataEncryption var1);
        }

        public static interface WithAuthConfig {
            public WithCreate withAuthConfig(AuthConfig var1);
        }

        public static interface WithStorage {
            public WithCreate withStorage(Storage var1);
        }

        public static interface WithVersion {
            public WithCreate withVersion(ServerVersion var1);
        }

        public static interface WithAdministratorLoginPassword {
            public WithCreate withAdministratorLoginPassword(String var1);
        }

        public static interface WithAdministratorLogin {
            public WithCreate withAdministratorLogin(String var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(UserAssignedIdentity var1);
        }

        public static interface WithSku {
            public WithCreate withSku(Sku var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithSku,
        WithIdentity,
        WithAdministratorLogin,
        WithAdministratorLoginPassword,
        WithVersion,
        WithStorage,
        WithAuthConfig,
        WithDataEncryption,
        WithBackup,
        WithNetwork,
        WithHighAvailability,
        WithSourceServerResourceId,
        WithPointInTimeUtc,
        WithAvailabilityZone,
        WithReplicationRole,
        WithCreateMode,
        WithCluster {
            public Server create();

            public Server create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

