/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationDbState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class DbMigrationStatus
implements JsonSerializable<DbMigrationStatus> {
    private String databaseName;
    private MigrationDbState migrationState;
    private String migrationOperation;
    private OffsetDateTime startedOn;
    private OffsetDateTime endedOn;
    private Integer fullLoadQueuedTables;
    private Integer fullLoadErroredTables;
    private Integer fullLoadLoadingTables;
    private Integer fullLoadCompletedTables;
    private Integer cdcUpdateCounter;
    private Integer cdcDeleteCounter;
    private Integer cdcInsertCounter;
    private Integer appliedChanges;
    private Integer incomingChanges;
    private Integer latency;
    private String message;

    public String databaseName() {
        return this.databaseName;
    }

    public DbMigrationStatus withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public MigrationDbState migrationState() {
        return this.migrationState;
    }

    public DbMigrationStatus withMigrationState(MigrationDbState migrationState) {
        this.migrationState = migrationState;
        return this;
    }

    public String migrationOperation() {
        return this.migrationOperation;
    }

    public DbMigrationStatus withMigrationOperation(String migrationOperation) {
        this.migrationOperation = migrationOperation;
        return this;
    }

    public OffsetDateTime startedOn() {
        return this.startedOn;
    }

    public DbMigrationStatus withStartedOn(OffsetDateTime startedOn) {
        this.startedOn = startedOn;
        return this;
    }

    public OffsetDateTime endedOn() {
        return this.endedOn;
    }

    public DbMigrationStatus withEndedOn(OffsetDateTime endedOn) {
        this.endedOn = endedOn;
        return this;
    }

    public Integer fullLoadQueuedTables() {
        return this.fullLoadQueuedTables;
    }

    public DbMigrationStatus withFullLoadQueuedTables(Integer fullLoadQueuedTables) {
        this.fullLoadQueuedTables = fullLoadQueuedTables;
        return this;
    }

    public Integer fullLoadErroredTables() {
        return this.fullLoadErroredTables;
    }

    public DbMigrationStatus withFullLoadErroredTables(Integer fullLoadErroredTables) {
        this.fullLoadErroredTables = fullLoadErroredTables;
        return this;
    }

    public Integer fullLoadLoadingTables() {
        return this.fullLoadLoadingTables;
    }

    public DbMigrationStatus withFullLoadLoadingTables(Integer fullLoadLoadingTables) {
        this.fullLoadLoadingTables = fullLoadLoadingTables;
        return this;
    }

    public Integer fullLoadCompletedTables() {
        return this.fullLoadCompletedTables;
    }

    public DbMigrationStatus withFullLoadCompletedTables(Integer fullLoadCompletedTables) {
        this.fullLoadCompletedTables = fullLoadCompletedTables;
        return this;
    }

    public Integer cdcUpdateCounter() {
        return this.cdcUpdateCounter;
    }

    public DbMigrationStatus withCdcUpdateCounter(Integer cdcUpdateCounter) {
        this.cdcUpdateCounter = cdcUpdateCounter;
        return this;
    }

    public Integer cdcDeleteCounter() {
        return this.cdcDeleteCounter;
    }

    public DbMigrationStatus withCdcDeleteCounter(Integer cdcDeleteCounter) {
        this.cdcDeleteCounter = cdcDeleteCounter;
        return this;
    }

    public Integer cdcInsertCounter() {
        return this.cdcInsertCounter;
    }

    public DbMigrationStatus withCdcInsertCounter(Integer cdcInsertCounter) {
        this.cdcInsertCounter = cdcInsertCounter;
        return this;
    }

    public Integer appliedChanges() {
        return this.appliedChanges;
    }

    public DbMigrationStatus withAppliedChanges(Integer appliedChanges) {
        this.appliedChanges = appliedChanges;
        return this;
    }

    public Integer incomingChanges() {
        return this.incomingChanges;
    }

    public DbMigrationStatus withIncomingChanges(Integer incomingChanges) {
        this.incomingChanges = incomingChanges;
        return this;
    }

    public Integer latency() {
        return this.latency;
    }

    public DbMigrationStatus withLatency(Integer latency) {
        this.latency = latency;
        return this;
    }

    public String message() {
        return this.message;
    }

    public DbMigrationStatus withMessage(String message) {
        this.message = message;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("databaseName", this.databaseName);
        jsonWriter.writeStringField("migrationState", this.migrationState == null ? null : this.migrationState.toString());
        jsonWriter.writeStringField("migrationOperation", this.migrationOperation);
        jsonWriter.writeStringField("startedOn", this.startedOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startedOn));
        jsonWriter.writeStringField("endedOn", this.endedOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endedOn));
        jsonWriter.writeNumberField("fullLoadQueuedTables", (Number)this.fullLoadQueuedTables);
        jsonWriter.writeNumberField("fullLoadErroredTables", (Number)this.fullLoadErroredTables);
        jsonWriter.writeNumberField("fullLoadLoadingTables", (Number)this.fullLoadLoadingTables);
        jsonWriter.writeNumberField("fullLoadCompletedTables", (Number)this.fullLoadCompletedTables);
        jsonWriter.writeNumberField("cdcUpdateCounter", (Number)this.cdcUpdateCounter);
        jsonWriter.writeNumberField("cdcDeleteCounter", (Number)this.cdcDeleteCounter);
        jsonWriter.writeNumberField("cdcInsertCounter", (Number)this.cdcInsertCounter);
        jsonWriter.writeNumberField("appliedChanges", (Number)this.appliedChanges);
        jsonWriter.writeNumberField("incomingChanges", (Number)this.incomingChanges);
        jsonWriter.writeNumberField("latency", (Number)this.latency);
        jsonWriter.writeStringField("message", this.message);
        return jsonWriter.writeEndObject();
    }

    public static DbMigrationStatus fromJson(JsonReader jsonReader) throws IOException {
        return (DbMigrationStatus)jsonReader.readObject(reader -> {
            DbMigrationStatus deserializedDbMigrationStatus = new DbMigrationStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("databaseName".equals(fieldName)) {
                    deserializedDbMigrationStatus.databaseName = reader.getString();
                    continue;
                }
                if ("migrationState".equals(fieldName)) {
                    deserializedDbMigrationStatus.migrationState = MigrationDbState.fromString(reader.getString());
                    continue;
                }
                if ("migrationOperation".equals(fieldName)) {
                    deserializedDbMigrationStatus.migrationOperation = reader.getString();
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedDbMigrationStatus.startedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endedOn".equals(fieldName)) {
                    deserializedDbMigrationStatus.endedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("fullLoadQueuedTables".equals(fieldName)) {
                    deserializedDbMigrationStatus.fullLoadQueuedTables = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("fullLoadErroredTables".equals(fieldName)) {
                    deserializedDbMigrationStatus.fullLoadErroredTables = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("fullLoadLoadingTables".equals(fieldName)) {
                    deserializedDbMigrationStatus.fullLoadLoadingTables = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("fullLoadCompletedTables".equals(fieldName)) {
                    deserializedDbMigrationStatus.fullLoadCompletedTables = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("cdcUpdateCounter".equals(fieldName)) {
                    deserializedDbMigrationStatus.cdcUpdateCounter = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("cdcDeleteCounter".equals(fieldName)) {
                    deserializedDbMigrationStatus.cdcDeleteCounter = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("cdcInsertCounter".equals(fieldName)) {
                    deserializedDbMigrationStatus.cdcInsertCounter = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("appliedChanges".equals(fieldName)) {
                    deserializedDbMigrationStatus.appliedChanges = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("incomingChanges".equals(fieldName)) {
                    deserializedDbMigrationStatus.incomingChanges = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("latency".equals(fieldName)) {
                    deserializedDbMigrationStatus.latency = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedDbMigrationStatus.message = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDbMigrationStatus;
        });
    }
}

