/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.VirtualNetworkSubnetUsagesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.VirtualNetworkSubnetUsageResultInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.VirtualNetworkSubnetUsageResultImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.models.VirtualNetworkSubnetUsageParameter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.VirtualNetworkSubnetUsageResult;
import com.azure.resourcemanager.postgresqlflexibleserver.models.VirtualNetworkSubnetUsages;

public final class VirtualNetworkSubnetUsagesImpl
implements VirtualNetworkSubnetUsages {
    private static final ClientLogger LOGGER = new ClientLogger(VirtualNetworkSubnetUsagesImpl.class);
    private final VirtualNetworkSubnetUsagesClient innerClient;
    private final PostgreSqlManager serviceManager;

    public VirtualNetworkSubnetUsagesImpl(VirtualNetworkSubnetUsagesClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<VirtualNetworkSubnetUsageResult> executeWithResponse(String locationName, VirtualNetworkSubnetUsageParameter parameters, Context context) {
        Response<VirtualNetworkSubnetUsageResultInner> inner = this.serviceClient().executeWithResponse(locationName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new VirtualNetworkSubnetUsageResultImpl((VirtualNetworkSubnetUsageResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public VirtualNetworkSubnetUsageResult execute(String locationName, VirtualNetworkSubnetUsageParameter parameters) {
        VirtualNetworkSubnetUsageResultInner inner = this.serviceClient().execute(locationName, parameters);
        if (inner != null) {
            return new VirtualNetworkSubnetUsageResultImpl(inner, this.manager());
        }
        return null;
    }

    private VirtualNetworkSubnetUsagesClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }
}

