/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.TuningOptionsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.TuningOptionsResourceInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.TuningOptionsResourceImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.models.TuningOptionEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.TuningOptions;
import com.azure.resourcemanager.postgresqlflexibleserver.models.TuningOptionsResource;

public final class TuningOptionsImpl
implements TuningOptions {
    private static final ClientLogger LOGGER = new ClientLogger(TuningOptionsImpl.class);
    private final TuningOptionsClient innerClient;
    private final PostgreSqlManager serviceManager;

    public TuningOptionsImpl(TuningOptionsClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<TuningOptionsResource> getWithResponse(String resourceGroupName, String serverName, TuningOptionEnum tuningOption, Context context) {
        Response<TuningOptionsResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, serverName, tuningOption, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TuningOptionsResourceImpl((TuningOptionsResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public TuningOptionsResource get(String resourceGroupName, String serverName, TuningOptionEnum tuningOption) {
        TuningOptionsResourceInner inner = this.serviceClient().get(resourceGroupName, serverName, tuningOption);
        if (inner != null) {
            return new TuningOptionsResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<TuningOptionsResource> listByServer(String resourceGroupName, String serverName) {
        PagedIterable<TuningOptionsResourceInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TuningOptionsResourceImpl((TuningOptionsResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<TuningOptionsResource> listByServer(String resourceGroupName, String serverName, Context context) {
        PagedIterable<TuningOptionsResourceInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TuningOptionsResourceImpl((TuningOptionsResourceInner)((Object)inner1), this.manager()));
    }

    private TuningOptionsClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }
}

