/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.TuningIndexesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.IndexRecommendationResourceInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.IndexRecommendationResourceImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.postgresqlflexibleserver.models.IndexRecommendationResource;
import com.azure.resourcemanager.postgresqlflexibleserver.models.RecommendationType;
import com.azure.resourcemanager.postgresqlflexibleserver.models.TuningIndexes;
import com.azure.resourcemanager.postgresqlflexibleserver.models.TuningOptionEnum;

public final class TuningIndexesImpl
implements TuningIndexes {
    private static final ClientLogger LOGGER = new ClientLogger(TuningIndexesImpl.class);
    private final TuningIndexesClient innerClient;
    private final PostgreSqlManager serviceManager;

    public TuningIndexesImpl(TuningIndexesClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<IndexRecommendationResource> listRecommendations(String resourceGroupName, String serverName, TuningOptionEnum tuningOption) {
        PagedIterable<IndexRecommendationResourceInner> inner = this.serviceClient().listRecommendations(resourceGroupName, serverName, tuningOption);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new IndexRecommendationResourceImpl((IndexRecommendationResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<IndexRecommendationResource> listRecommendations(String resourceGroupName, String serverName, TuningOptionEnum tuningOption, RecommendationType recommendationType, Context context) {
        PagedIterable<IndexRecommendationResourceInner> inner = this.serviceClient().listRecommendations(resourceGroupName, serverName, tuningOption, recommendationType, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new IndexRecommendationResourceImpl((IndexRecommendationResourceInner)((Object)inner1), this.manager()));
    }

    private TuningIndexesClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }
}

