/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.MigrationNameAvailabilityResourceInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.PostgreSqlManagementClientImpl;
import reactor.core.publisher.Mono;

public final class ResourceProvidersClientImpl
implements ResourceProvidersClient {
    private final ResourceProvidersService service;
    private final PostgreSqlManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(ResourceProvidersClientImpl.class);

    ResourceProvidersClientImpl(PostgreSqlManagementClientImpl client) {
        this.service = (ResourceProvidersService)RestProxy.create(ResourceProvidersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MigrationNameAvailabilityResourceInner>> checkMigrationNameAvailabilityWithResponseAsync(String subscriptionId, String resourceGroupName, String targetDbServerName, MigrationNameAvailabilityResourceInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetDbServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetDbServerName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkMigrationNameAvailability(this.client.getEndpoint(), this.client.getApiVersion(), subscriptionId, resourceGroupName, targetDbServerName, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MigrationNameAvailabilityResourceInner> checkMigrationNameAvailabilityAsync(String subscriptionId, String resourceGroupName, String targetDbServerName, MigrationNameAvailabilityResourceInner parameters) {
        return this.checkMigrationNameAvailabilityWithResponseAsync(subscriptionId, resourceGroupName, targetDbServerName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((MigrationNameAvailabilityResourceInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MigrationNameAvailabilityResourceInner> checkMigrationNameAvailabilityWithResponse(String subscriptionId, String resourceGroupName, String targetDbServerName, MigrationNameAvailabilityResourceInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetDbServerName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetDbServerName is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.checkMigrationNameAvailabilitySync(this.client.getEndpoint(), this.client.getApiVersion(), subscriptionId, resourceGroupName, targetDbServerName, parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MigrationNameAvailabilityResourceInner checkMigrationNameAvailability(String subscriptionId, String resourceGroupName, String targetDbServerName, MigrationNameAvailabilityResourceInner parameters) {
        return (MigrationNameAvailabilityResourceInner)this.checkMigrationNameAvailabilityWithResponse(subscriptionId, resourceGroupName, targetDbServerName, parameters, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="PostgreSqlManagement")
    public static interface ResourceProvidersService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{targetDbServerName}/checkMigrationNameAvailability")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MigrationNameAvailabilityResourceInner>> checkMigrationNameAvailability(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="targetDbServerName") String var5, @BodyParam(value="application/json") MigrationNameAvailabilityResourceInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{targetDbServerName}/checkMigrationNameAvailability")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<MigrationNameAvailabilityResourceInner> checkMigrationNameAvailabilitySync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="targetDbServerName") String var5, @BodyParam(value="application/json") MigrationNameAvailabilityResourceInner var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

