/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.MigrationsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.MigrationResourceInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.MigrationResourceImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationListFilter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationResource;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Migrations;

public final class MigrationsImpl
implements Migrations {
    private static final ClientLogger LOGGER = new ClientLogger(MigrationsImpl.class);
    private final MigrationsClient innerClient;
    private final PostgreSqlManager serviceManager;

    public MigrationsImpl(MigrationsClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<MigrationResource> getWithResponse(String subscriptionId, String resourceGroupName, String targetDbServerName, String migrationName, Context context) {
        Response<MigrationResourceInner> inner = this.serviceClient().getWithResponse(subscriptionId, resourceGroupName, targetDbServerName, migrationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new MigrationResourceImpl((MigrationResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public MigrationResource get(String subscriptionId, String resourceGroupName, String targetDbServerName, String migrationName) {
        MigrationResourceInner inner = this.serviceClient().get(subscriptionId, resourceGroupName, targetDbServerName, migrationName);
        if (inner != null) {
            return new MigrationResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String subscriptionId, String resourceGroupName, String targetDbServerName, String migrationName, Context context) {
        return this.serviceClient().deleteWithResponse(subscriptionId, resourceGroupName, targetDbServerName, migrationName, context);
    }

    @Override
    public void delete(String subscriptionId, String resourceGroupName, String targetDbServerName, String migrationName) {
        this.serviceClient().delete(subscriptionId, resourceGroupName, targetDbServerName, migrationName);
    }

    @Override
    public PagedIterable<MigrationResource> listByTargetServer(String subscriptionId, String resourceGroupName, String targetDbServerName) {
        PagedIterable<MigrationResourceInner> inner = this.serviceClient().listByTargetServer(subscriptionId, resourceGroupName, targetDbServerName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new MigrationResourceImpl((MigrationResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<MigrationResource> listByTargetServer(String subscriptionId, String resourceGroupName, String targetDbServerName, MigrationListFilter migrationListFilter, Context context) {
        PagedIterable<MigrationResourceInner> inner = this.serviceClient().listByTargetServer(subscriptionId, resourceGroupName, targetDbServerName, migrationListFilter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new MigrationResourceImpl((MigrationResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public MigrationResource getById(String id) {
        String subscriptionId = ResourceManagerUtils.getValueFromIdByName(id, "subscriptions");
        if (subscriptionId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'subscriptions'.", id)));
        }
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String targetDbServerName = ResourceManagerUtils.getValueFromIdByName(id, "flexibleServers");
        if (targetDbServerName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String migrationName = ResourceManagerUtils.getValueFromIdByName(id, "migrations");
        if (migrationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'migrations'.", id)));
        }
        return (MigrationResource)this.getWithResponse(subscriptionId, resourceGroupName, targetDbServerName, migrationName, Context.NONE).getValue();
    }

    @Override
    public Response<MigrationResource> getByIdWithResponse(String id, Context context) {
        String subscriptionId = ResourceManagerUtils.getValueFromIdByName(id, "subscriptions");
        if (subscriptionId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'subscriptions'.", id)));
        }
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String targetDbServerName = ResourceManagerUtils.getValueFromIdByName(id, "flexibleServers");
        if (targetDbServerName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String migrationName = ResourceManagerUtils.getValueFromIdByName(id, "migrations");
        if (migrationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'migrations'.", id)));
        }
        return this.getWithResponse(subscriptionId, resourceGroupName, targetDbServerName, migrationName, context);
    }

    @Override
    public void deleteById(String id) {
        String subscriptionId = ResourceManagerUtils.getValueFromIdByName(id, "subscriptions");
        if (subscriptionId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'subscriptions'.", id)));
        }
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String targetDbServerName = ResourceManagerUtils.getValueFromIdByName(id, "flexibleServers");
        if (targetDbServerName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String migrationName = ResourceManagerUtils.getValueFromIdByName(id, "migrations");
        if (migrationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'migrations'.", id)));
        }
        this.deleteWithResponse(subscriptionId, resourceGroupName, targetDbServerName, migrationName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String subscriptionId = ResourceManagerUtils.getValueFromIdByName(id, "subscriptions");
        if (subscriptionId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'subscriptions'.", id)));
        }
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String targetDbServerName = ResourceManagerUtils.getValueFromIdByName(id, "flexibleServers");
        if (targetDbServerName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String migrationName = ResourceManagerUtils.getValueFromIdByName(id, "migrations");
        if (migrationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'migrations'.", id)));
        }
        return this.deleteWithResponse(subscriptionId, resourceGroupName, targetDbServerName, migrationName, context);
    }

    private MigrationsClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public MigrationResourceImpl define(String name) {
        return new MigrationResourceImpl(name, this.manager());
    }
}

