/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.CheckNameAvailabilityWithLocationsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.NameAvailabilityInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.PostgreSqlManagementClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CheckNameAvailabilityRequest;
import reactor.core.publisher.Mono;

public final class CheckNameAvailabilityWithLocationsClientImpl
implements CheckNameAvailabilityWithLocationsClient {
    private final CheckNameAvailabilityWithLocationsService service;
    private final PostgreSqlManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(CheckNameAvailabilityWithLocationsClientImpl.class);

    CheckNameAvailabilityWithLocationsClientImpl(PostgreSqlManagementClientImpl client) {
        this.service = (CheckNameAvailabilityWithLocationsService)RestProxy.create(CheckNameAvailabilityWithLocationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<NameAvailabilityInner>> executeWithResponseAsync(String locationName, CheckNameAvailabilityRequest nameAvailabilityRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (nameAvailabilityRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nameAvailabilityRequest is required and cannot be null."));
        }
        nameAvailabilityRequest.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.execute(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), locationName, nameAvailabilityRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<NameAvailabilityInner> executeAsync(String locationName, CheckNameAvailabilityRequest nameAvailabilityRequest) {
        return this.executeWithResponseAsync(locationName, nameAvailabilityRequest).flatMap(res -> Mono.justOrEmpty((Object)((NameAvailabilityInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NameAvailabilityInner> executeWithResponse(String locationName, CheckNameAvailabilityRequest nameAvailabilityRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (locationName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (nameAvailabilityRequest == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nameAvailabilityRequest is required and cannot be null."));
        }
        nameAvailabilityRequest.validate();
        String accept = "application/json";
        return this.service.executeSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), locationName, nameAvailabilityRequest, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NameAvailabilityInner execute(String locationName, CheckNameAvailabilityRequest nameAvailabilityRequest) {
        return (NameAvailabilityInner)this.executeWithResponse(locationName, nameAvailabilityRequest, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="PostgreSqlManagement")
    public static interface CheckNameAvailabilityWithLocationsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.DBforPostgreSQL/locations/{locationName}/checkNameAvailability")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NameAvailabilityInner>> execute(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="locationName") String var4, @BodyParam(value="application/json") CheckNameAvailabilityRequest var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.DBforPostgreSQL/locations/{locationName}/checkNameAvailability")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<NameAvailabilityInner> executeSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="locationName") String var4, @BodyParam(value="application/json") CheckNameAvailabilityRequest var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

