/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class LogFileProperties
implements JsonSerializable<LogFileProperties> {
    private OffsetDateTime createdTime;
    private OffsetDateTime lastModifiedTime;
    private Long sizeInKb;
    private String type;
    private String url;

    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    public LogFileProperties withCreatedTime(OffsetDateTime createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public LogFileProperties withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
        return this;
    }

    public Long sizeInKb() {
        return this.sizeInKb;
    }

    public LogFileProperties withSizeInKb(Long sizeInKb) {
        this.sizeInKb = sizeInKb;
        return this;
    }

    public String type() {
        return this.type;
    }

    public LogFileProperties withType(String type) {
        this.type = type;
        return this;
    }

    public String url() {
        return this.url;
    }

    public LogFileProperties withUrl(String url) {
        this.url = url;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("createdTime", this.createdTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdTime));
        jsonWriter.writeStringField("lastModifiedTime", this.lastModifiedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedTime));
        jsonWriter.writeNumberField("sizeInKb", (Number)this.sizeInKb);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("url", this.url);
        return jsonWriter.writeEndObject();
    }

    public static LogFileProperties fromJson(JsonReader jsonReader) throws IOException {
        return (LogFileProperties)jsonReader.readObject(reader -> {
            LogFileProperties deserializedLogFileProperties = new LogFileProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("createdTime".equals(fieldName)) {
                    deserializedLogFileProperties.createdTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedLogFileProperties.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("sizeInKb".equals(fieldName)) {
                    deserializedLogFileProperties.sizeInKb = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedLogFileProperties.type = reader.getString();
                    continue;
                }
                if ("url".equals(fieldName)) {
                    deserializedLogFileProperties.url = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLogFileProperties;
        });
    }
}

