/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ValidationSummaryItem;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class DbLevelValidationStatus
implements JsonSerializable<DbLevelValidationStatus> {
    private String databaseName;
    private OffsetDateTime startedOn;
    private OffsetDateTime endedOn;
    private List<ValidationSummaryItem> summary;

    public String databaseName() {
        return this.databaseName;
    }

    public DbLevelValidationStatus withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public OffsetDateTime startedOn() {
        return this.startedOn;
    }

    public DbLevelValidationStatus withStartedOn(OffsetDateTime startedOn) {
        this.startedOn = startedOn;
        return this;
    }

    public OffsetDateTime endedOn() {
        return this.endedOn;
    }

    public DbLevelValidationStatus withEndedOn(OffsetDateTime endedOn) {
        this.endedOn = endedOn;
        return this;
    }

    public List<ValidationSummaryItem> summary() {
        return this.summary;
    }

    public DbLevelValidationStatus withSummary(List<ValidationSummaryItem> summary) {
        this.summary = summary;
        return this;
    }

    public void validate() {
        if (this.summary() != null) {
            this.summary().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("databaseName", this.databaseName);
        jsonWriter.writeStringField("startedOn", this.startedOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startedOn));
        jsonWriter.writeStringField("endedOn", this.endedOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endedOn));
        jsonWriter.writeArrayField("summary", this.summary, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DbLevelValidationStatus fromJson(JsonReader jsonReader) throws IOException {
        return (DbLevelValidationStatus)jsonReader.readObject(reader -> {
            DbLevelValidationStatus deserializedDbLevelValidationStatus = new DbLevelValidationStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("databaseName".equals(fieldName)) {
                    deserializedDbLevelValidationStatus.databaseName = reader.getString();
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedDbLevelValidationStatus.startedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endedOn".equals(fieldName)) {
                    deserializedDbLevelValidationStatus.endedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("summary".equals(fieldName)) {
                    List summary;
                    deserializedDbLevelValidationStatus.summary = summary = reader.readArray(reader1 -> ValidationSummaryItem.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDbLevelValidationStatus;
        });
    }
}

