/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.TuningConfigurationsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.SessionDetailsResourceInner;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.SessionResourceInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.SessionDetailsResourceImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.SessionResourceImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ConfigTuningRequestParameter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.SessionDetailsResource;
import com.azure.resourcemanager.postgresqlflexibleserver.models.SessionResource;
import com.azure.resourcemanager.postgresqlflexibleserver.models.TuningConfigurations;
import com.azure.resourcemanager.postgresqlflexibleserver.models.TuningOptionEnum;

public final class TuningConfigurationsImpl
implements TuningConfigurations {
    private static final ClientLogger LOGGER = new ClientLogger(TuningConfigurationsImpl.class);
    private final TuningConfigurationsClient innerClient;
    private final PostgreSqlManager serviceManager;

    public TuningConfigurationsImpl(TuningConfigurationsClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public void enable(String resourceGroupName, String serverName, TuningOptionEnum tuningOption) {
        this.serviceClient().enable(resourceGroupName, serverName, tuningOption);
    }

    @Override
    public void enable(String resourceGroupName, String serverName, TuningOptionEnum tuningOption, Context context) {
        this.serviceClient().enable(resourceGroupName, serverName, tuningOption, context);
    }

    @Override
    public void disable(String resourceGroupName, String serverName, TuningOptionEnum tuningOption) {
        this.serviceClient().disable(resourceGroupName, serverName, tuningOption);
    }

    @Override
    public void disable(String resourceGroupName, String serverName, TuningOptionEnum tuningOption, Context context) {
        this.serviceClient().disable(resourceGroupName, serverName, tuningOption, context);
    }

    @Override
    public void startSession(String resourceGroupName, String serverName, TuningOptionEnum tuningOption, ConfigTuningRequestParameter configTuningRequest) {
        this.serviceClient().startSession(resourceGroupName, serverName, tuningOption, configTuningRequest);
    }

    @Override
    public void startSession(String resourceGroupName, String serverName, TuningOptionEnum tuningOption, ConfigTuningRequestParameter configTuningRequest, Context context) {
        this.serviceClient().startSession(resourceGroupName, serverName, tuningOption, configTuningRequest, context);
    }

    @Override
    public void stopSession(String resourceGroupName, String serverName, TuningOptionEnum tuningOption) {
        this.serviceClient().stopSession(resourceGroupName, serverName, tuningOption);
    }

    @Override
    public void stopSession(String resourceGroupName, String serverName, TuningOptionEnum tuningOption, Context context) {
        this.serviceClient().stopSession(resourceGroupName, serverName, tuningOption, context);
    }

    @Override
    public PagedIterable<SessionResource> listSessions(String resourceGroupName, String serverName, TuningOptionEnum tuningOption) {
        PagedIterable<SessionResourceInner> inner = this.serviceClient().listSessions(resourceGroupName, serverName, tuningOption);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SessionResourceImpl((SessionResourceInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<SessionResource> listSessions(String resourceGroupName, String serverName, TuningOptionEnum tuningOption, Context context) {
        PagedIterable<SessionResourceInner> inner = this.serviceClient().listSessions(resourceGroupName, serverName, tuningOption, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SessionResourceImpl((SessionResourceInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<SessionDetailsResource> listSessionDetails(String resourceGroupName, String serverName, TuningOptionEnum tuningOption, String sessionId) {
        PagedIterable<SessionDetailsResourceInner> inner = this.serviceClient().listSessionDetails(resourceGroupName, serverName, tuningOption, sessionId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SessionDetailsResourceImpl((SessionDetailsResourceInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<SessionDetailsResource> listSessionDetails(String resourceGroupName, String serverName, TuningOptionEnum tuningOption, String sessionId, Context context) {
        PagedIterable<SessionDetailsResourceInner> inner = this.serviceClient().listSessionDetails(resourceGroupName, serverName, tuningOption, sessionId, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SessionDetailsResourceImpl((SessionDetailsResourceInner)inner1, this.manager()));
    }

    private TuningConfigurationsClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }
}

