/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CapabilityBase;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CapabilityStatus;
import com.azure.resourcemanager.postgresqlflexibleserver.models.FastProvisioningEditionCapability;
import com.azure.resourcemanager.postgresqlflexibleserver.models.FastProvisioningSupportedEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.FlexibleServerEditionCapability;
import com.azure.resourcemanager.postgresqlflexibleserver.models.GeoBackupSupportedEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.OnlineResizeSupportedEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.RestrictedEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerVersionCapability;
import com.azure.resourcemanager.postgresqlflexibleserver.models.StorageAutoGrowthSupportedEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.SupportedFeature;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ZoneRedundantHaAndGeoBackupSupportedEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ZoneRedundantHaSupportedEnum;
import java.io.IOException;
import java.util.List;

public final class FlexibleServerCapabilityInner
extends CapabilityBase {
    private String name;
    private List<FlexibleServerEditionCapability> supportedServerEditions;
    private List<ServerVersionCapability> supportedServerVersions;
    private List<SupportedFeature> supportedFeatures;
    private FastProvisioningSupportedEnum fastProvisioningSupported;
    private List<FastProvisioningEditionCapability> supportedFastProvisioningEditions;
    private GeoBackupSupportedEnum geoBackupSupported;
    private ZoneRedundantHaSupportedEnum zoneRedundantHaSupported;
    private ZoneRedundantHaAndGeoBackupSupportedEnum zoneRedundantHaAndGeoBackupSupported;
    private StorageAutoGrowthSupportedEnum storageAutoGrowthSupported;
    private OnlineResizeSupportedEnum onlineResizeSupported;
    private RestrictedEnum restricted;
    private String reason;
    private CapabilityStatus status;

    public String name() {
        return this.name;
    }

    public FlexibleServerCapabilityInner withName(String name) {
        this.name = name;
        return this;
    }

    public List<FlexibleServerEditionCapability> supportedServerEditions() {
        return this.supportedServerEditions;
    }

    public List<ServerVersionCapability> supportedServerVersions() {
        return this.supportedServerVersions;
    }

    public List<SupportedFeature> supportedFeatures() {
        return this.supportedFeatures;
    }

    public FastProvisioningSupportedEnum fastProvisioningSupported() {
        return this.fastProvisioningSupported;
    }

    public List<FastProvisioningEditionCapability> supportedFastProvisioningEditions() {
        return this.supportedFastProvisioningEditions;
    }

    public GeoBackupSupportedEnum geoBackupSupported() {
        return this.geoBackupSupported;
    }

    public ZoneRedundantHaSupportedEnum zoneRedundantHaSupported() {
        return this.zoneRedundantHaSupported;
    }

    public ZoneRedundantHaAndGeoBackupSupportedEnum zoneRedundantHaAndGeoBackupSupported() {
        return this.zoneRedundantHaAndGeoBackupSupported;
    }

    public StorageAutoGrowthSupportedEnum storageAutoGrowthSupported() {
        return this.storageAutoGrowthSupported;
    }

    public OnlineResizeSupportedEnum onlineResizeSupported() {
        return this.onlineResizeSupported;
    }

    public RestrictedEnum restricted() {
        return this.restricted;
    }

    @Override
    public String reason() {
        return this.reason;
    }

    @Override
    public CapabilityStatus status() {
        return this.status;
    }

    @Override
    public void validate() {
        if (this.supportedServerEditions() != null) {
            this.supportedServerEditions().forEach(e -> e.validate());
        }
        if (this.supportedServerVersions() != null) {
            this.supportedServerVersions().forEach(e -> e.validate());
        }
        if (this.supportedFeatures() != null) {
            this.supportedFeatures().forEach(e -> e.validate());
        }
        if (this.supportedFastProvisioningEditions() != null) {
            this.supportedFastProvisioningEditions().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static FlexibleServerCapabilityInner fromJson(JsonReader jsonReader) throws IOException {
        return (FlexibleServerCapabilityInner)jsonReader.readObject(reader -> {
            FlexibleServerCapabilityInner deserializedFlexibleServerCapabilityInner = new FlexibleServerCapabilityInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedFlexibleServerCapabilityInner.status = CapabilityStatus.fromString(reader.getString());
                    continue;
                }
                if ("reason".equals(fieldName)) {
                    deserializedFlexibleServerCapabilityInner.reason = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedFlexibleServerCapabilityInner.name = reader.getString();
                    continue;
                }
                if ("supportedServerEditions".equals(fieldName)) {
                    List supportedServerEditions;
                    deserializedFlexibleServerCapabilityInner.supportedServerEditions = supportedServerEditions = reader.readArray(reader1 -> FlexibleServerEditionCapability.fromJson(reader1));
                    continue;
                }
                if ("supportedServerVersions".equals(fieldName)) {
                    List supportedServerVersions;
                    deserializedFlexibleServerCapabilityInner.supportedServerVersions = supportedServerVersions = reader.readArray(reader1 -> ServerVersionCapability.fromJson(reader1));
                    continue;
                }
                if ("supportedFeatures".equals(fieldName)) {
                    List supportedFeatures;
                    deserializedFlexibleServerCapabilityInner.supportedFeatures = supportedFeatures = reader.readArray(reader1 -> SupportedFeature.fromJson(reader1));
                    continue;
                }
                if ("fastProvisioningSupported".equals(fieldName)) {
                    deserializedFlexibleServerCapabilityInner.fastProvisioningSupported = FastProvisioningSupportedEnum.fromString(reader.getString());
                    continue;
                }
                if ("supportedFastProvisioningEditions".equals(fieldName)) {
                    List supportedFastProvisioningEditions;
                    deserializedFlexibleServerCapabilityInner.supportedFastProvisioningEditions = supportedFastProvisioningEditions = reader.readArray(reader1 -> FastProvisioningEditionCapability.fromJson(reader1));
                    continue;
                }
                if ("geoBackupSupported".equals(fieldName)) {
                    deserializedFlexibleServerCapabilityInner.geoBackupSupported = GeoBackupSupportedEnum.fromString(reader.getString());
                    continue;
                }
                if ("zoneRedundantHaSupported".equals(fieldName)) {
                    deserializedFlexibleServerCapabilityInner.zoneRedundantHaSupported = ZoneRedundantHaSupportedEnum.fromString(reader.getString());
                    continue;
                }
                if ("zoneRedundantHaAndGeoBackupSupported".equals(fieldName)) {
                    deserializedFlexibleServerCapabilityInner.zoneRedundantHaAndGeoBackupSupported = ZoneRedundantHaAndGeoBackupSupportedEnum.fromString(reader.getString());
                    continue;
                }
                if ("storageAutoGrowthSupported".equals(fieldName)) {
                    deserializedFlexibleServerCapabilityInner.storageAutoGrowthSupported = StorageAutoGrowthSupportedEnum.fromString(reader.getString());
                    continue;
                }
                if ("onlineResizeSupported".equals(fieldName)) {
                    deserializedFlexibleServerCapabilityInner.onlineResizeSupported = OnlineResizeSupportedEnum.fromString(reader.getString());
                    continue;
                }
                if ("restricted".equals(fieldName)) {
                    deserializedFlexibleServerCapabilityInner.restricted = RestrictedEnum.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFlexibleServerCapabilityInner;
        });
    }
}

