/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.playwrighttesting.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.playwrighttesting.PlaywrightTestingManager;
import com.azure.resourcemanager.playwrighttesting.fluent.AccountsClient;
import com.azure.resourcemanager.playwrighttesting.fluent.models.AccountInner;
import com.azure.resourcemanager.playwrighttesting.fluent.models.CheckNameAvailabilityResponseInner;
import com.azure.resourcemanager.playwrighttesting.implementation.AccountImpl;
import com.azure.resourcemanager.playwrighttesting.implementation.CheckNameAvailabilityResponseImpl;
import com.azure.resourcemanager.playwrighttesting.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.playwrighttesting.models.Account;
import com.azure.resourcemanager.playwrighttesting.models.Accounts;
import com.azure.resourcemanager.playwrighttesting.models.CheckNameAvailabilityRequest;
import com.azure.resourcemanager.playwrighttesting.models.CheckNameAvailabilityResponse;

public final class AccountsImpl
implements Accounts {
    private static final ClientLogger LOGGER = new ClientLogger(AccountsImpl.class);
    private final AccountsClient innerClient;
    private final PlaywrightTestingManager serviceManager;

    public AccountsImpl(AccountsClient innerClient, PlaywrightTestingManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Account> getByResourceGroupWithResponse(String resourceGroupName, String accountName, Context context) {
        Response<AccountInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, accountName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AccountImpl((AccountInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Account getByResourceGroup(String resourceGroupName, String accountName) {
        AccountInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, accountName);
        if (inner != null) {
            return new AccountImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String accountName) {
        this.serviceClient().delete(resourceGroupName, accountName);
    }

    @Override
    public void delete(String resourceGroupName, String accountName, Context context) {
        this.serviceClient().delete(resourceGroupName, accountName, context);
    }

    @Override
    public PagedIterable<Account> listByResourceGroup(String resourceGroupName) {
        PagedIterable<AccountInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AccountImpl((AccountInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Account> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<AccountInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AccountImpl((AccountInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Account> list() {
        PagedIterable<AccountInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AccountImpl((AccountInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Account> list(Context context) {
        PagedIterable<AccountInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AccountImpl((AccountInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<CheckNameAvailabilityResponse> checkNameAvailabilityWithResponse(CheckNameAvailabilityRequest body, Context context) {
        Response<CheckNameAvailabilityResponseInner> inner = this.serviceClient().checkNameAvailabilityWithResponse(body, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CheckNameAvailabilityResponseImpl((CheckNameAvailabilityResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public CheckNameAvailabilityResponse checkNameAvailability(CheckNameAvailabilityRequest body) {
        CheckNameAvailabilityResponseInner inner = this.serviceClient().checkNameAvailability(body);
        if (inner != null) {
            return new CheckNameAvailabilityResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Account getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "accounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'accounts'.", id)));
        }
        return (Account)this.getByResourceGroupWithResponse(resourceGroupName, accountName, Context.NONE).getValue();
    }

    @Override
    public Response<Account> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "accounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'accounts'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, accountName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "accounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'accounts'.", id)));
        }
        this.delete(resourceGroupName, accountName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "accounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'accounts'.", id)));
        }
        this.delete(resourceGroupName, accountName, context);
    }

    private AccountsClient serviceClient() {
        return this.innerClient;
    }

    private PlaywrightTestingManager manager() {
        return this.serviceManager;
    }

    @Override
    public AccountImpl define(String name) {
        return new AccountImpl(name, this.manager());
    }
}

