/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.playwrighttesting.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.playwrighttesting.models.AccountUpdateProperties;
import java.io.IOException;
import java.util.Map;

public final class AccountUpdate
implements JsonSerializable<AccountUpdate> {
    private Map<String, String> tags;
    private AccountUpdateProperties properties;

    public Map<String, String> tags() {
        return this.tags;
    }

    public AccountUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public AccountUpdateProperties properties() {
        return this.properties;
    }

    public AccountUpdate withProperties(AccountUpdateProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static AccountUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (AccountUpdate)jsonReader.readObject(reader -> {
            AccountUpdate deserializedAccountUpdate = new AccountUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedAccountUpdate.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAccountUpdate.properties = AccountUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAccountUpdate;
        });
    }
}

