/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.playwrighttesting.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.playwrighttesting.fluent.models.AccountInner;
import com.azure.resourcemanager.playwrighttesting.models.AccountProperties;
import com.azure.resourcemanager.playwrighttesting.models.AccountUpdateProperties;
import java.util.Map;

public interface Account {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public AccountProperties properties();

    public SystemData systemData();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public AccountInner innerModel();

    public Update update();

    public Account refresh();

    public Account refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithProperties {
            public Update withProperties(AccountUpdateProperties var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithProperties {
        public Account apply();

        public Account apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithProperties {
            public WithCreate withProperties(AccountProperties var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithProperties {
            public Account create();

            public Account create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

