/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.playwrighttesting.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.playwrighttesting.fluent.models.QuotaInner;
import java.io.IOException;
import java.util.List;

public final class QuotaListResult
implements JsonSerializable<QuotaListResult> {
    private List<QuotaInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(QuotaListResult.class);

    private QuotaListResult() {
    }

    public List<QuotaInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model QuotaListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static QuotaListResult fromJson(JsonReader jsonReader) throws IOException {
        return (QuotaListResult)jsonReader.readObject(reader -> {
            QuotaListResult deserializedQuotaListResult = new QuotaListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedQuotaListResult.value = value = reader.readArray(reader1 -> QuotaInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedQuotaListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedQuotaListResult;
        });
    }
}

