/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.playwright.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.playwright.PlaywrightManager;
import com.azure.resourcemanager.playwright.fluent.PlaywrightWorkspacesClient;
import com.azure.resourcemanager.playwright.fluent.models.CheckNameAvailabilityResponseInner;
import com.azure.resourcemanager.playwright.fluent.models.PlaywrightWorkspaceInner;
import com.azure.resourcemanager.playwright.implementation.CheckNameAvailabilityResponseImpl;
import com.azure.resourcemanager.playwright.implementation.PlaywrightWorkspaceImpl;
import com.azure.resourcemanager.playwright.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.playwright.models.CheckNameAvailabilityRequest;
import com.azure.resourcemanager.playwright.models.CheckNameAvailabilityResponse;
import com.azure.resourcemanager.playwright.models.PlaywrightWorkspace;
import com.azure.resourcemanager.playwright.models.PlaywrightWorkspaces;

public final class PlaywrightWorkspacesImpl
implements PlaywrightWorkspaces {
    private static final ClientLogger LOGGER = new ClientLogger(PlaywrightWorkspacesImpl.class);
    private final PlaywrightWorkspacesClient innerClient;
    private final PlaywrightManager serviceManager;

    public PlaywrightWorkspacesImpl(PlaywrightWorkspacesClient innerClient, PlaywrightManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<PlaywrightWorkspace> getByResourceGroupWithResponse(String resourceGroupName, String playwrightWorkspaceName, Context context) {
        Response<PlaywrightWorkspaceInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, playwrightWorkspaceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PlaywrightWorkspaceImpl((PlaywrightWorkspaceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PlaywrightWorkspace getByResourceGroup(String resourceGroupName, String playwrightWorkspaceName) {
        PlaywrightWorkspaceInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, playwrightWorkspaceName);
        if (inner != null) {
            return new PlaywrightWorkspaceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String playwrightWorkspaceName) {
        this.serviceClient().delete(resourceGroupName, playwrightWorkspaceName);
    }

    @Override
    public void delete(String resourceGroupName, String playwrightWorkspaceName, Context context) {
        this.serviceClient().delete(resourceGroupName, playwrightWorkspaceName, context);
    }

    @Override
    public PagedIterable<PlaywrightWorkspace> listByResourceGroup(String resourceGroupName) {
        PagedIterable<PlaywrightWorkspaceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PlaywrightWorkspaceImpl((PlaywrightWorkspaceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PlaywrightWorkspace> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<PlaywrightWorkspaceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PlaywrightWorkspaceImpl((PlaywrightWorkspaceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PlaywrightWorkspace> list() {
        PagedIterable<PlaywrightWorkspaceInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PlaywrightWorkspaceImpl((PlaywrightWorkspaceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PlaywrightWorkspace> list(Context context) {
        PagedIterable<PlaywrightWorkspaceInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PlaywrightWorkspaceImpl((PlaywrightWorkspaceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<CheckNameAvailabilityResponse> checkNameAvailabilityWithResponse(CheckNameAvailabilityRequest body, Context context) {
        Response<CheckNameAvailabilityResponseInner> inner = this.serviceClient().checkNameAvailabilityWithResponse(body, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CheckNameAvailabilityResponseImpl((CheckNameAvailabilityResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public CheckNameAvailabilityResponse checkNameAvailability(CheckNameAvailabilityRequest body) {
        CheckNameAvailabilityResponseInner inner = this.serviceClient().checkNameAvailability(body);
        if (inner != null) {
            return new CheckNameAvailabilityResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PlaywrightWorkspace getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String playwrightWorkspaceName = ResourceManagerUtils.getValueFromIdByName(id, "playwrightWorkspaces");
        if (playwrightWorkspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'playwrightWorkspaces'.", id)));
        }
        return (PlaywrightWorkspace)this.getByResourceGroupWithResponse(resourceGroupName, playwrightWorkspaceName, Context.NONE).getValue();
    }

    @Override
    public Response<PlaywrightWorkspace> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String playwrightWorkspaceName = ResourceManagerUtils.getValueFromIdByName(id, "playwrightWorkspaces");
        if (playwrightWorkspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'playwrightWorkspaces'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, playwrightWorkspaceName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String playwrightWorkspaceName = ResourceManagerUtils.getValueFromIdByName(id, "playwrightWorkspaces");
        if (playwrightWorkspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'playwrightWorkspaces'.", id)));
        }
        this.delete(resourceGroupName, playwrightWorkspaceName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String playwrightWorkspaceName = ResourceManagerUtils.getValueFromIdByName(id, "playwrightWorkspaces");
        if (playwrightWorkspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'playwrightWorkspaces'.", id)));
        }
        this.delete(resourceGroupName, playwrightWorkspaceName, context);
    }

    private PlaywrightWorkspacesClient serviceClient() {
        return this.innerClient;
    }

    private PlaywrightManager manager() {
        return this.serviceManager;
    }

    @Override
    public PlaywrightWorkspaceImpl define(String name) {
        return new PlaywrightWorkspaceImpl(name, this.manager());
    }
}

