/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.playwright.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.playwright.PlaywrightManager;
import com.azure.resourcemanager.playwright.fluent.models.PlaywrightWorkspaceInner;
import com.azure.resourcemanager.playwright.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.playwright.models.PlaywrightWorkspace;
import com.azure.resourcemanager.playwright.models.PlaywrightWorkspaceProperties;
import com.azure.resourcemanager.playwright.models.PlaywrightWorkspaceUpdate;
import com.azure.resourcemanager.playwright.models.PlaywrightWorkspaceUpdateProperties;
import java.util.Collections;
import java.util.Map;

public final class PlaywrightWorkspaceImpl
implements PlaywrightWorkspace,
PlaywrightWorkspace.Definition,
PlaywrightWorkspace.Update {
    private PlaywrightWorkspaceInner innerObject;
    private final PlaywrightManager serviceManager;
    private String resourceGroupName;
    private String playwrightWorkspaceName;
    private PlaywrightWorkspaceUpdate updateProperties;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public PlaywrightWorkspaceProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public PlaywrightWorkspaceInner innerModel() {
        return this.innerObject;
    }

    private PlaywrightManager manager() {
        return this.serviceManager;
    }

    @Override
    public PlaywrightWorkspaceImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public PlaywrightWorkspace create() {
        this.innerObject = this.serviceManager.serviceClient().getPlaywrightWorkspaces().createOrUpdate(this.resourceGroupName, this.playwrightWorkspaceName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public PlaywrightWorkspace create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPlaywrightWorkspaces().createOrUpdate(this.resourceGroupName, this.playwrightWorkspaceName, this.innerModel(), context);
        return this;
    }

    PlaywrightWorkspaceImpl(String name, PlaywrightManager serviceManager) {
        this.innerObject = new PlaywrightWorkspaceInner();
        this.serviceManager = serviceManager;
        this.playwrightWorkspaceName = name;
    }

    @Override
    public PlaywrightWorkspaceImpl update() {
        this.updateProperties = new PlaywrightWorkspaceUpdate();
        return this;
    }

    @Override
    public PlaywrightWorkspace apply() {
        this.innerObject = (PlaywrightWorkspaceInner)((Object)this.serviceManager.serviceClient().getPlaywrightWorkspaces().updateWithResponse(this.resourceGroupName, this.playwrightWorkspaceName, this.updateProperties, Context.NONE).getValue());
        return this;
    }

    @Override
    public PlaywrightWorkspace apply(Context context) {
        this.innerObject = (PlaywrightWorkspaceInner)((Object)this.serviceManager.serviceClient().getPlaywrightWorkspaces().updateWithResponse(this.resourceGroupName, this.playwrightWorkspaceName, this.updateProperties, context).getValue());
        return this;
    }

    PlaywrightWorkspaceImpl(PlaywrightWorkspaceInner innerObject, PlaywrightManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.playwrightWorkspaceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "playwrightWorkspaces");
    }

    @Override
    public PlaywrightWorkspace refresh() {
        this.innerObject = (PlaywrightWorkspaceInner)((Object)this.serviceManager.serviceClient().getPlaywrightWorkspaces().getByResourceGroupWithResponse(this.resourceGroupName, this.playwrightWorkspaceName, Context.NONE).getValue());
        return this;
    }

    @Override
    public PlaywrightWorkspace refresh(Context context) {
        this.innerObject = (PlaywrightWorkspaceInner)((Object)this.serviceManager.serviceClient().getPlaywrightWorkspaces().getByResourceGroupWithResponse(this.resourceGroupName, this.playwrightWorkspaceName, context).getValue());
        return this;
    }

    @Override
    public PlaywrightWorkspaceImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public PlaywrightWorkspaceImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public PlaywrightWorkspaceImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateProperties.withTags(tags);
        return this;
    }

    @Override
    public PlaywrightWorkspaceImpl withProperties(PlaywrightWorkspaceProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public PlaywrightWorkspaceImpl withProperties(PlaywrightWorkspaceUpdateProperties properties) {
        this.updateProperties.withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

