/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.planetarycomputer.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.planetarycomputer.models.ManagedServiceIdentityUpdate;
import java.io.IOException;
import java.util.Map;

public final class GeoCatalogUpdate
implements JsonSerializable<GeoCatalogUpdate> {
    private Map<String, String> tags;
    private ManagedServiceIdentityUpdate identity;

    public Map<String, String> tags() {
        return this.tags;
    }

    public GeoCatalogUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public ManagedServiceIdentityUpdate identity() {
        return this.identity;
    }

    public GeoCatalogUpdate withIdentity(ManagedServiceIdentityUpdate identity) {
        this.identity = identity;
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static GeoCatalogUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (GeoCatalogUpdate)jsonReader.readObject(reader -> {
            GeoCatalogUpdate deserializedGeoCatalogUpdate = new GeoCatalogUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedGeoCatalogUpdate.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedGeoCatalogUpdate.identity = ManagedServiceIdentityUpdate.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGeoCatalogUpdate;
        });
    }
}

