/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.planetarycomputer.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.planetarycomputer.models.AutoGeneratedDomainNameLabelScope;
import com.azure.resourcemanager.planetarycomputer.models.CatalogTier;
import com.azure.resourcemanager.planetarycomputer.models.ProvisioningState;
import java.io.IOException;

public final class GeoCatalogProperties
implements JsonSerializable<GeoCatalogProperties> {
    private CatalogTier tier;
    private String catalogUri;
    private ProvisioningState provisioningState;
    private AutoGeneratedDomainNameLabelScope autoGeneratedDomainNameLabelScope;

    public CatalogTier tier() {
        return this.tier;
    }

    public GeoCatalogProperties withTier(CatalogTier tier) {
        this.tier = tier;
        return this;
    }

    public String catalogUri() {
        return this.catalogUri;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public AutoGeneratedDomainNameLabelScope autoGeneratedDomainNameLabelScope() {
        return this.autoGeneratedDomainNameLabelScope;
    }

    public GeoCatalogProperties withAutoGeneratedDomainNameLabelScope(AutoGeneratedDomainNameLabelScope autoGeneratedDomainNameLabelScope) {
        this.autoGeneratedDomainNameLabelScope = autoGeneratedDomainNameLabelScope;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("tier", this.tier == null ? null : this.tier.toString());
        jsonWriter.writeStringField("autoGeneratedDomainNameLabelScope", this.autoGeneratedDomainNameLabelScope == null ? null : this.autoGeneratedDomainNameLabelScope.toString());
        return jsonWriter.writeEndObject();
    }

    public static GeoCatalogProperties fromJson(JsonReader jsonReader) throws IOException {
        return (GeoCatalogProperties)jsonReader.readObject(reader -> {
            GeoCatalogProperties deserializedGeoCatalogProperties = new GeoCatalogProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tier".equals(fieldName)) {
                    deserializedGeoCatalogProperties.tier = CatalogTier.fromString(reader.getString());
                    continue;
                }
                if ("catalogUri".equals(fieldName)) {
                    deserializedGeoCatalogProperties.catalogUri = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedGeoCatalogProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("autoGeneratedDomainNameLabelScope".equals(fieldName)) {
                    deserializedGeoCatalogProperties.autoGeneratedDomainNameLabelScope = AutoGeneratedDomainNameLabelScope.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGeoCatalogProperties;
        });
    }
}

