/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.planetarycomputer.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.planetarycomputer.PlanetaryComputerManager;
import com.azure.resourcemanager.planetarycomputer.fluent.GeoCatalogsClient;
import com.azure.resourcemanager.planetarycomputer.fluent.models.GeoCatalogInner;
import com.azure.resourcemanager.planetarycomputer.implementation.GeoCatalogImpl;
import com.azure.resourcemanager.planetarycomputer.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.planetarycomputer.models.GeoCatalog;
import com.azure.resourcemanager.planetarycomputer.models.GeoCatalogs;

public final class GeoCatalogsImpl
implements GeoCatalogs {
    private static final ClientLogger LOGGER = new ClientLogger(GeoCatalogsImpl.class);
    private final GeoCatalogsClient innerClient;
    private final PlanetaryComputerManager serviceManager;

    public GeoCatalogsImpl(GeoCatalogsClient innerClient, PlanetaryComputerManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<GeoCatalog> getByResourceGroupWithResponse(String resourceGroupName, String catalogName, Context context) {
        Response<GeoCatalogInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, catalogName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new GeoCatalogImpl((GeoCatalogInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public GeoCatalog getByResourceGroup(String resourceGroupName, String catalogName) {
        GeoCatalogInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, catalogName);
        if (inner != null) {
            return new GeoCatalogImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String catalogName) {
        this.serviceClient().delete(resourceGroupName, catalogName);
    }

    @Override
    public void delete(String resourceGroupName, String catalogName, Context context) {
        this.serviceClient().delete(resourceGroupName, catalogName, context);
    }

    @Override
    public PagedIterable<GeoCatalog> listByResourceGroup(String resourceGroupName) {
        PagedIterable<GeoCatalogInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GeoCatalogImpl((GeoCatalogInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<GeoCatalog> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<GeoCatalogInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GeoCatalogImpl((GeoCatalogInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<GeoCatalog> list() {
        PagedIterable<GeoCatalogInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GeoCatalogImpl((GeoCatalogInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<GeoCatalog> list(Context context) {
        PagedIterable<GeoCatalogInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GeoCatalogImpl((GeoCatalogInner)((Object)inner1), this.manager()));
    }

    @Override
    public GeoCatalog getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String catalogName = ResourceManagerUtils.getValueFromIdByName(id, "geoCatalogs");
        if (catalogName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'geoCatalogs'.", id)));
        }
        return (GeoCatalog)this.getByResourceGroupWithResponse(resourceGroupName, catalogName, Context.NONE).getValue();
    }

    @Override
    public Response<GeoCatalog> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String catalogName = ResourceManagerUtils.getValueFromIdByName(id, "geoCatalogs");
        if (catalogName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'geoCatalogs'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, catalogName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String catalogName = ResourceManagerUtils.getValueFromIdByName(id, "geoCatalogs");
        if (catalogName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'geoCatalogs'.", id)));
        }
        this.delete(resourceGroupName, catalogName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String catalogName = ResourceManagerUtils.getValueFromIdByName(id, "geoCatalogs");
        if (catalogName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'geoCatalogs'.", id)));
        }
        this.delete(resourceGroupName, catalogName, context);
    }

    private GeoCatalogsClient serviceClient() {
        return this.innerClient;
    }

    private PlanetaryComputerManager manager() {
        return this.serviceManager;
    }

    @Override
    public GeoCatalogImpl define(String name) {
        return new GeoCatalogImpl(name, this.manager());
    }
}

