/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.planetarycomputer.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.planetarycomputer.PlanetaryComputerManager;
import com.azure.resourcemanager.planetarycomputer.fluent.models.GeoCatalogInner;
import com.azure.resourcemanager.planetarycomputer.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.planetarycomputer.models.GeoCatalog;
import com.azure.resourcemanager.planetarycomputer.models.GeoCatalogProperties;
import com.azure.resourcemanager.planetarycomputer.models.GeoCatalogUpdate;
import com.azure.resourcemanager.planetarycomputer.models.ManagedServiceIdentity;
import com.azure.resourcemanager.planetarycomputer.models.ManagedServiceIdentityUpdate;
import java.util.Collections;
import java.util.Map;

public final class GeoCatalogImpl
implements GeoCatalog,
GeoCatalog.Definition,
GeoCatalog.Update {
    private GeoCatalogInner innerObject;
    private final PlanetaryComputerManager serviceManager;
    private String resourceGroupName;
    private String catalogName;
    private GeoCatalogUpdate updateProperties;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public GeoCatalogProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public ManagedServiceIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public GeoCatalogInner innerModel() {
        return this.innerObject;
    }

    private PlanetaryComputerManager manager() {
        return this.serviceManager;
    }

    @Override
    public GeoCatalogImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public GeoCatalog create() {
        this.innerObject = this.serviceManager.serviceClient().getGeoCatalogs().create(this.resourceGroupName, this.catalogName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public GeoCatalog create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getGeoCatalogs().create(this.resourceGroupName, this.catalogName, this.innerModel(), context);
        return this;
    }

    GeoCatalogImpl(String name, PlanetaryComputerManager serviceManager) {
        this.innerObject = new GeoCatalogInner();
        this.serviceManager = serviceManager;
        this.catalogName = name;
    }

    @Override
    public GeoCatalogImpl update() {
        this.updateProperties = new GeoCatalogUpdate();
        return this;
    }

    @Override
    public GeoCatalog apply() {
        this.innerObject = this.serviceManager.serviceClient().getGeoCatalogs().update(this.resourceGroupName, this.catalogName, this.updateProperties, Context.NONE);
        return this;
    }

    @Override
    public GeoCatalog apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getGeoCatalogs().update(this.resourceGroupName, this.catalogName, this.updateProperties, context);
        return this;
    }

    GeoCatalogImpl(GeoCatalogInner innerObject, PlanetaryComputerManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.catalogName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "geoCatalogs");
    }

    @Override
    public GeoCatalog refresh() {
        this.innerObject = (GeoCatalogInner)((Object)this.serviceManager.serviceClient().getGeoCatalogs().getByResourceGroupWithResponse(this.resourceGroupName, this.catalogName, Context.NONE).getValue());
        return this;
    }

    @Override
    public GeoCatalog refresh(Context context) {
        this.innerObject = (GeoCatalogInner)((Object)this.serviceManager.serviceClient().getGeoCatalogs().getByResourceGroupWithResponse(this.resourceGroupName, this.catalogName, context).getValue());
        return this;
    }

    @Override
    public GeoCatalogImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public GeoCatalogImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public GeoCatalogImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateProperties.withTags(tags);
        return this;
    }

    @Override
    public GeoCatalogImpl withProperties(GeoCatalogProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public GeoCatalogImpl withIdentity(ManagedServiceIdentity identity) {
        this.innerModel().withIdentity(identity);
        return this;
    }

    @Override
    public GeoCatalogImpl withIdentity(ManagedServiceIdentityUpdate identity) {
        this.updateProperties.withIdentity(identity);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

