/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.RelayType;
import java.io.IOException;

public final class VirtualMachineAssignRelayParameters
implements JsonSerializable<VirtualMachineAssignRelayParameters> {
    private String machineId;
    private RelayType relayType;
    private static final ClientLogger LOGGER = new ClientLogger(VirtualMachineAssignRelayParameters.class);

    public String machineId() {
        return this.machineId;
    }

    public VirtualMachineAssignRelayParameters withMachineId(String machineId) {
        this.machineId = machineId;
        return this;
    }

    public RelayType relayType() {
        return this.relayType;
    }

    public VirtualMachineAssignRelayParameters withRelayType(RelayType relayType) {
        this.relayType = relayType;
        return this;
    }

    public void validate() {
        if (this.machineId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property machineId in model VirtualMachineAssignRelayParameters"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("machineId", this.machineId);
        jsonWriter.writeStringField("relayType", this.relayType == null ? null : this.relayType.toString());
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineAssignRelayParameters fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineAssignRelayParameters)jsonReader.readObject(reader -> {
            VirtualMachineAssignRelayParameters deserializedVirtualMachineAssignRelayParameters = new VirtualMachineAssignRelayParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("machineId".equals(fieldName)) {
                    deserializedVirtualMachineAssignRelayParameters.machineId = reader.getString();
                    continue;
                }
                if ("relayType".equals(fieldName)) {
                    deserializedVirtualMachineAssignRelayParameters.relayType = RelayType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineAssignRelayParameters;
        });
    }
}

