/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class StorageApplianceCommandSpecification
implements JsonSerializable<StorageApplianceCommandSpecification> {
    private List<String> arguments;
    private String command;
    private static final ClientLogger LOGGER = new ClientLogger(StorageApplianceCommandSpecification.class);

    public List<String> arguments() {
        return this.arguments;
    }

    public StorageApplianceCommandSpecification withArguments(List<String> arguments) {
        this.arguments = arguments;
        return this;
    }

    public String command() {
        return this.command;
    }

    public StorageApplianceCommandSpecification withCommand(String command) {
        this.command = command;
        return this;
    }

    public void validate() {
        if (this.command() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property command in model StorageApplianceCommandSpecification"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("command", this.command);
        jsonWriter.writeArrayField("arguments", this.arguments, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static StorageApplianceCommandSpecification fromJson(JsonReader jsonReader) throws IOException {
        return (StorageApplianceCommandSpecification)jsonReader.readObject(reader -> {
            StorageApplianceCommandSpecification deserializedStorageApplianceCommandSpecification = new StorageApplianceCommandSpecification();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("command".equals(fieldName)) {
                    deserializedStorageApplianceCommandSpecification.command = reader.getString();
                    continue;
                }
                if ("arguments".equals(fieldName)) {
                    List arguments;
                    deserializedStorageApplianceCommandSpecification.arguments = arguments = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageApplianceCommandSpecification;
        });
    }
}

