/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.OsDiskCreateOption;
import com.azure.resourcemanager.networkcloud.models.OsDiskDeleteOption;
import java.io.IOException;

public final class OsDisk
implements JsonSerializable<OsDisk> {
    private OsDiskCreateOption createOption;
    private OsDiskDeleteOption deleteOption;
    private long diskSizeGB;

    public OsDiskCreateOption createOption() {
        return this.createOption;
    }

    public OsDisk withCreateOption(OsDiskCreateOption createOption) {
        this.createOption = createOption;
        return this;
    }

    public OsDiskDeleteOption deleteOption() {
        return this.deleteOption;
    }

    public OsDisk withDeleteOption(OsDiskDeleteOption deleteOption) {
        this.deleteOption = deleteOption;
        return this;
    }

    public long diskSizeGB() {
        return this.diskSizeGB;
    }

    public OsDisk withDiskSizeGB(long diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeLongField("diskSizeGB", this.diskSizeGB);
        jsonWriter.writeStringField("createOption", this.createOption == null ? null : this.createOption.toString());
        jsonWriter.writeStringField("deleteOption", this.deleteOption == null ? null : this.deleteOption.toString());
        return jsonWriter.writeEndObject();
    }

    public static OsDisk fromJson(JsonReader jsonReader) throws IOException {
        return (OsDisk)jsonReader.readObject(reader -> {
            OsDisk deserializedOsDisk = new OsDisk();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("diskSizeGB".equals(fieldName)) {
                    deserializedOsDisk.diskSizeGB = reader.getLong();
                    continue;
                }
                if ("createOption".equals(fieldName)) {
                    deserializedOsDisk.createOption = OsDiskCreateOption.fromString(reader.getString());
                    continue;
                }
                if ("deleteOption".equals(fieldName)) {
                    deserializedOsDisk.deleteOption = OsDiskDeleteOption.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOsDisk;
        });
    }
}

